DATA = xlsread('data/JME2014_data.xls');
% line 1: Dates
% line 2: Tax Revenues (in logs, per capita)
% line 3: Govt Spending (in logs, per capita)
% line 4: Output (in logs, per capita)
% line 5: Narrative Shocks

DATARR = xlsread('data/RRTAXSHOCKS.xls');

 dates = DATA(:,1);
 vars = [DATA(:,2:4)];
 [T,n]  = size(vars);

 DAT.taxshocks = [DATARR(:,2)];

 % Romer and Romer approach (Differences)
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 MA.q   = 12;         %Number of lags of tax shocks
 MA.DET = [ones(T,1)];
 TSHOCKS = lagmatrix(DAT.taxshocks,0:MA.q);
 sel  = ((DATARR(:,1)>1949.75)&(DATARR(:,1)<2007));
 TSHOCKS(isnan(TSHOCKS))=0;
 MA.TSHOCKS = TSHOCKS(sel==1,:);
 MA.vars  = vars;
 MA.shocksize = 100*Total(1)*100;
 MA = doMA(MA);
 MA.irs =  MA.irs*MA.shocksize;

GDP_growth_response = [[MA.irs([4:4:12],3)-[0; MA.irs([4:4:12-4],3)]]' MA.irs(12,3)];
round(GDP_growth_response,2)

TMIRS(:,1) = GDP_growth_response;
