% Load the data
DATA = xlsread('data/JME2014_data.xls');
% line 1: Dates
% line 2: Tax Revenues (in logs, per capita)
% line 3: Govt Spending (in logs, per capita)
% line 4: Output (in logs, per capita)
% line 5: Narrative Shocks

%  Proxy SVAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 dates = DATA(:,1);
 VARNA.vars  = [DATA(:,2:4)];
 VARNA.p = 4;
 [T,n]  = size(VARNA.vars);
 VARNA.DET = [ones(T,1) (1:T)' ((1:T).^2)' dates==1975.25];
 VARNA.irhor = 20;
 VARNA.proxies = [DATA(:,5)];
 
 % Demean the narrative shocks
  for j=1:size(VARNA.proxies,2)
     VARNA.proxies(VARNA.proxies(:,j)~=0,j)=(VARNA.proxies(VARNA.proxies(:,j)~=0,j)-mean(VARNA.proxies(VARNA.proxies(:,j)~=0,j)));
  end
  
VARNA     = doPVAR(VARNA);

DAT.TRY = 0.1746; % Average ratio of federal tax revenues to GDP
shocksize = Total(1)*100/DAT.TRY;
VAR.irs = VARNA.irs*VARNA.scale_adjustment*shocksize;

GDP_growth_response = [[VAR.irs([4:4:12],3)-[0; VAR.irs([4:4:12-4],3)]]' VAR.irs(12,3)];
round(GDP_growth_response,2)

TMIRS(:,5) = GDP_growth_response;


