%Import_AER_Data
load DATASET;

% VAR specification
%%%%%%%%%%%%%%%%%%%%
VAR.p               = 4;           % Number of Lags
VAR.irhor           = 20;          % Impulse Response Horizon
VAR.select_vars     = {'APITR','ACITR','PITB','CITB','GOV','RGDP','DEBT'};
VAR.vars            = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,VAR.select_vars)));
VAR.DET             = ones(length(VAR.vars),1);
VAR.MAP             = containers.Map([VAR.select_vars,{'PITREV','CITREV'}],[1:size(VAR.vars,2) 8 9]);
VAR.proxies         = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'m_PI','m_CI'})));

VAR     = doPVAR(VAR);

% Individual 
shocksize = IIT(1)*100;
VARII.irs = VAR.irs(:,:,1)*VAR.scale_adjustment(1)*shocksize;

display('Individual Tax Reform')
GDP_growth_response1 = [[VARII.irs([4:4:12],6)-[0; VARII.irs([4:4:12-4],6)]]' VARII.irs(12,6)];
round(GDP_growth_response1,2)

% Business 
shocksize = CIT(1)*100;
VARB1.irs = VAR.irs(:,:,2)*VAR.scale_adjustment(2)*shocksize;

display('Business Tax Reform')
GDP_growth_response2 = [[VARB1.irs([4:4:12],6)-[0; VARB1.irs([4:4:12-4],6)]]' VARB1.irs(12,6)];
round(GDP_growth_response2,2)

% International
shocksize = CIT2(1)*100;
VARB2.irs = VAR.irs(:,:,2)*VAR.scale_adjustment(2)*shocksize;

display('International Tax Reform')
GDP_growth_response3 = [[VARB2.irs([4:4:12],6)-[0; VARB2.irs([4:4:12-4],6)]]' VARB2.irs(12,6)];
round(GDP_growth_response3,2)

display('Total')
round(GDP_growth_response1+GDP_growth_response2+GDP_growth_response3,2)
