% Load Data
DATASET.TSERIES = xlsread('data/MMO_Figure8_data.xls'); 
DATASET.LABEL   = {'DATES','LNAMTRTOP1','LNAMTRB99','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINCTOP1','AINCB99','PROX_mtrTOP1','PROX_mtrB99'};
DATASET.UNIT    = [0         1             1          2        1      2       2      1         1        1       1        1             2           2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) Top 1% Tax Units','1/(1-AMTR) Btm 99% Tax Units','Unemployment Rate','Real GDP','Inflation',...
    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income Top 1% Tax Units','Income Btm 99% Tax Units','AMTR T1 proxy','AMTR B99 proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
VAR.sb              = 1946;  % Sample start year
VAR.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=VAR.sb)&(DATASET.TSERIES(:,1)<=VAR.se),:);
VAR.dates           = TSERIES(:,1);
ttrend               = (VAR.sb:VAR.se)'/1000;                      
VAR.DET             = [ttrend ttrend.^2  detrend(VAR.dates==1949,'constant') detrend(VAR.dates==2008,'constant')...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
VAR.p               = 2; % Lag length
VAR.irhor           = 6; % Length of IR horizon 
VAR.select_variables= {'LNAMTRTOP1','LNAMTRB99','AINCTOP1','AINCB99','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT'};
VAR.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,VAR.select_variables)));
VAR.proxies         = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX_mtrTOP1','PROX_mtrB99'})));
VAR.MAP             = containers.Map([VAR.select_variables],[1:size(VAR.vars,2)]);   

VAR                = doPVAR(VAR); 

irs_GDP_t1amtr_shock   =  -VAR.irs(:,6,1)*(log(1-(0.4520-0.0266))-log(1-0.4520))*100*VAR.scale_adjustment(1);
irs_GDP_b99amtr_shock  =  -VAR.irs(:,6,2)*(log(1-(0.278-0.0278))-log(1-0.278))*100*VAR.scale_adjustment(2);
 
irs = irs_GDP_t1amtr_shock+irs_GDP_b99amtr_shock;

GDP_growth_response = [[irs(1:3)-[0; irs(1:2)]]' irs(3)];
round(GDP_growth_response,2)
