% Load Data
DATASET.TSERIES = xlsread('data/MMO_Figure7_data.xls'); 
DATASET.LABEL   = {'DATES','LNAMTR1','LNAVTAX','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX_mtr','PROX_liab_total'};
DATASET.UNIT    = [0         1         1        2        1      2       2      1         1        1       1     2           2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Average Tax Rate','Unemployment Rate','Real GDP','Inflation',...
    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy','ATR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
VAR.sb              = 1946;  % Sample start year
VAR.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=VAR.sb)&(DATASET.TSERIES(:,1)<=VAR.se),:);
VAR.dates           = TSERIES(:,1);
VAR.DET             = [detrend(VAR.dates==1949,'constant') detrend(VAR.dates==2008,'constant')...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
VAR.p               = 2; % Lag length
VAR.irhor           = 6; % Length of IR horizon 
VAR.select_variables= {'LNAMTR1','LNAVTAX','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
VAR.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,VAR.select_variables)));
VAR.proxies         = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX_mtr','PROX_liab_total'})));
VAR.MAP             = containers.Map([VAR.select_variables],[1:size(VAR.vars,2)]);   

% Estimate SVARIV model
VAR                = doPVAR(VAR); 

irs_GDP_amtr_shock =  -VAR.irs(:,4,1)*(log(1-(0.2911-0.0275))-log(1-0.2911))*100*VAR.scale_adjustment(1);
irs_GDP_atr_shock  =  -VAR.irs(:,4,2)*0.0182*100*VAR.scale_adjustment(2);

irs = irs_GDP_amtr_shock+irs_GDP_atr_shock;

GDP_growth_response = [[irs(1:3)-[0; irs(1:2)]]' irs(3)];
round(GDP_growth_response,2)
