% Load Data
DATASET.TSERIES = xlsread('data/MMO_Figure5_data.xls'); 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation', ...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
VAR.sb              = 1946;  % Sample start year
VAR.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=VAR.sb)&(DATASET.TSERIES(:,1)<=VAR.se),:);
VAR.dates           = TSERIES(:,1);
VAR.DET             = [detrend(VAR.dates==1949,'constant') detrend(VAR.dates==2008,'constant')...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
VAR.p               = 2; % Lag length
VAR.irhor           = 6; % Length of IR horizon 
VAR.select_variables= {'LNAMTR1','AINC','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT'};
VAR.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,VAR.select_variables)));
VAR.proxies         = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
VAR.MAP             = containers.Map([VAR.select_variables],[1:size(VAR.vars,2)]);   

VAR     = doPVAR(VAR);

shocksize =  -VAR.scale_adjustment*(log(1-(0.2911-0.0275))-log(1-0.2911))*100;
VAR.irs = VAR.irs*shocksize;

GDP_growth_response = [[VAR.irs(1:3,3)-[0; VAR.irs(1:2,3)]]' VAR.irs(3,3)];
round(GDP_growth_response,2)


