DATA = xlsread('data/JME2014_data.xls');
% line 1: Dates
% line 2: Tax Revenues (in logs, per capita)
% line 3: Govt Spending (in logs, per capita)
% line 4: Output (in logs, per capita)
% line 5: Narrative Shocks

DATARR = xlsread('data/RRTAXSHOCKS.xls');

 dates = DATA(:,1);
 vars = [DATA(:,2:4)];
 [T,n]  = size(vars);

 DAT.taxshocks = [DATARR(:,2)];

 % Do Favero Giavazzi Approach (Levels with Quadratic Trend)
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 FG.q = 0;          %Number of lags of tax shocks
 FG.p =  4;
 FG.DET = [ones(T,1) (1:T)' ((1:T).^2)' dates==1975.25];
 TSHOCKS = lagmatrix(DAT.taxshocks,0:FG.q);
 TSHOCKS(isnan(TSHOCKS))=0;
 sel  = ((DATARR(:,1)>1949.75)&(DATARR(:,1)<2007));
 FG.TSHOCKS = TSHOCKS(sel==1,:);
 FG.vars  = vars;
 FG.irhor = 20;
 FG.shocksize = 100*Total(1)*100;
 FG   = doHYB(FG);
 FG.irs = FG.irs*FG.shocksize; 


GDP_growth_response = [[FG.irs([4:4:12],3)-[0; FG.irs([4:4:12-4],3)]]' FG.irs(12,3)];
round(GDP_growth_response,2)

TMIRS(:,2) = GDP_growth_response;