DATA = xlsread('data/JME2014_data.xls');
% line 1: Dates
% line 2: Tax Revenues (in logs, per capita)
% line 3: Govt Spending (in logs, per capita)
% line 4: Output (in logs, per capita)
% line 5: Narrative Shocks

%  Blanchard Perotti SVAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 dates      = DATA(:,1);
 VAR.vars   = [DATA(:,2:4)];
 VAR.p      =  4;
 [T,n]      = size(VAR.vars);
 VAR.DET    = [ones(T,1) (1:T)' ((1:T).^2)' dates==1975.25];
 VAR.irhor  = 20;
 VAR.BP.thetaY = 2.08; 
 VAR.BP.gammaT = 0; VAR.BP.gammaY = 0;
 VAR.d0     = [-0.0382;-0.0196;0.0691;0.0217;0.0232;0.0086];
 DAT.TRY    = 0.1746; % Average ratio of federal tax revenues to GDP
 VAR = doBPVAR(VAR);

 VAR.tshocksize =  (Total(1)/(1-VAR.BP.thetaY*(-0.08)))/DAT.TRY*100;
 VAR.irs=VAR.irs*VAR.tshocksize;
GDP_growth_response = [[VAR.irs([4:4:12],3)-[0; VAR.irs([4:4:12-4],3)]]' VAR.irs(12,3)];
round(GDP_growth_response,2)
TMIRS(:,4) = GDP_growth_response;