function VAR = doPVAR(VAR)

 VARSLAGS = lagmatrix(VAR.vars,1:VAR.p);
 VARSLAGS = VARSLAGS(VAR.p+1:end,:);
 VARS     = VAR.vars(VAR.p+1:end,:);
 TAXSHOCKS = VAR.proxies(VAR.p+1:end,:);

 [VAR.T,VAR.n]    = size(VARS);
  VAR.k =size(TAXSHOCKS,2);
 
% Run VAR
%%%%%%%%%
VAR.bet=[VARSLAGS VAR.DET(VAR.p+1:end,:)]\VARS; 
VAR.res = VARS-[VARSLAGS VAR.DET(VAR.p+1:end,:)]*VAR.bet;
VAR.Sigma = (VAR.res'*VAR.res)/(VAR.T-size(VAR.bet,1));
       
zt  = VAR.res(:,1:VAR.k);
zex = VAR.res(:,VAR.k+1:end);

proxies     =  TAXSHOCKS;
zthat       =  [ones(length(proxies),1) proxies]*([ones(length(proxies),1) proxies]\zt);
zeta        =  zthat\zex ;
resex       =  zex-zt*zeta; 
zexhat      =  resex*(resex\zex);
teta        =  zexhat\zt;

irs = [];

 if VAR.k==1
 
 irs(VAR.p+1,:) = [1  zeta];    
    for tt=2:VAR.irhor
    lvars = (irs(VAR.p+tt-1:-1:tt,:))';
    irs(VAR.p+tt,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);     
    end 
 VAR.irs(1:VAR.irhor,1:VAR.n) = irs(VAR.p+1:end,:);
 VAR.scale_adjustment = inv(1-zeta*teta);
 
 elseif VAR.k==2
 
     rest = zt-zex*teta;
     SigmaTSigmaTp =rest'*rest/(VAR.T-size(VAR.bet,1));
        
     s1 = sqrt(SigmaTSigmaTp(1,1));
     a  = SigmaTSigmaTp(2,1)/s1;
     s2 = sqrt(SigmaTSigmaTp(2,2)-a^2);
     SigmaTl = [s1 0 ; a s2];
   
     s2 = sqrt(SigmaTSigmaTp(2,2));
     b  = SigmaTSigmaTp(1,2)/s2;
     s1 = sqrt(SigmaTSigmaTp(1,1)-b^2);
     SigmaTu = [s1 b; 0 s2];
     
     
     impact1= [((eye(VAR.k)-zeta*teta)\zeta)*teta+eye(VAR.k) (eye(VAR.k)-zeta*teta)\zeta]'*SigmaTu;
     impact2= [((eye(VAR.k)-zeta*teta)\zeta)*teta+eye(VAR.k) (eye(VAR.k)-zeta*teta)\zeta]'*SigmaTl;
     
     D = [impact1(:,1) impact2(:,2)];
     
     scale_adjustment1 = (((eye(VAR.k)-zeta*teta)\zeta)*teta+eye(VAR.k))'*SigmaTu/SigmaTu(1,1);
     scale_adjustment2 = (((eye(VAR.k)-zeta*teta)\zeta)*teta+eye(VAR.k))'*SigmaTl/SigmaTl(2,2);
     VAR.scale_adjustment = [scale_adjustment1(1,1)  scale_adjustment2(2,2)];
     
     for i = 1:VAR.k
         irs = [];
         irs(VAR.p+1,:) = D(:,i)/D(i,i);
         for tt=2:VAR.irhor
         lvars = (irs(VAR.p+tt-1:-1:tt,:))';
         irs(VAR.p+tt,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);     
         end
        VAR.irs(1:VAR.irhor,1:VAR.n,i) = irs(VAR.p+1:end,:);
     end
 end




