% THE NEAR TERM GROWTH IMPACT OF THE TAX CUT AND JOBS ACT
%
% by Karel Mertens, February 2018
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addpath('auxiliary_files')
% Data from Jan 26 NIPA release (millions of current dollars)
NGDP_2017   = 19386801; % Gross Domestic Product  Table 1.1.5 line 1

PITB_2017Q4 = 16630764 ... % Personal Income  Table 2.1 line 1
              + 1318879 ... % + Contributions for Gov SS Table 2.1 line 25
              - 2878892; % - Personal Current Transfer Receipts Table 2.1 line 16
                           
CITB_2017Q3 =  2213656;   %  Corporate Profits with IVA and CCadj Table 1.12 line 13
%Using Q3 since Q4 is not yet available in Jan 26 release


% Table 1
Total = [-135.7+0.25*(-280.0) 0.75*(-280.0)+0.25*(-258.8) 0.75*(-258.8)+0.25*(-220.8) -1456.0]*1000/NGDP_2017;  
round(Total*100,1)

IIT   = [-75.3+0.25*(-188.8) 0.75*(-188.8)+0.25*(-171.9) 0.75*(-171.9)+0.25*(-156.3) -1126.6]*1000/PITB_2017Q4;
round(IIT*100,1)

CIT   = [-129.3+0.25*(-133.8) 0.75*(-133.8)+0.25*(-112.9) 0.75*(-112.9)+0.25*(-92.5) -653.8]*1000/CITB_2017Q3;
round(CIT*100,1)

CIT2  = [68.9+0.25*(42.6) 0.75*(42.6)+0.25*(26.0) 0.75*(26.0)+0.25*(28.0) 324.4]*1000/CITB_2017Q3;
round(CIT2*100,1)


% Table II
display('Romer-Romer 2010'); 
do_RomerRomer

display('Favero-Giavazzi 2012'); 
do_FaveroGiavazzi

display('Mertens-Ravn 2012'); 
do_MertensRavn12

display('Blanchard-Perotti 2002'); 
do_BlanchardPerotti

display('Mertens-Ravn 2014'); 
do_MertensRavn14

display('Caldara Kamps 2017')
irs = [-0.57 -0.61 -0.51]/0.7*Total(1)*100; % Note, estimates from model with simple rule
GDP_growth_response = [irs(1) irs(2)-irs(1) irs(3)-irs(2) irs(3)];
round(GDP_growth_response,2)
TMIRS(:,6) = GDP_growth_response;

display('Average of Tax Multiplier-based Estimates')
GDP_growth_response = round(mean(TMIRS,2)',2)

display('Mertens-Ravn 2013'); 
do_MertensRavn13

display('Mertens-Montiel Olea 2018: AMTR'); 
do_MertensMontielOlea1

display('Mertens-Montiel Olea 2018: AMTR and ATR'); 
do_MertensMontielOlea2

display('Mertens-Montiel Olea 2018: Top and Bottom AMTR'); 
do_MertensMontielOlea3

display('Zidar: Top and Bottom ATR');  % Estimates based on Table 4 in Zidar (2018)
B90=0.5*IIT(1)*PITB_2017Q4/NGDP_2017*100*[0.66 -3.24 -1.21];
T10=0.5*IIT(1)*PITB_2017Q4/NGDP_2017*100*[1.78 -2.13 -0.76];
irs = B90+T10;
GDP_growth_response = [irs  sum(irs)];
round(GDP_growth_response,2)



