%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Table IV
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation', ...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

REG.vars_tax        = -log(1-AMTR(:,2:end));
prox                = NARR(:,[6 6:13]);
prox(isnan(prox))   = 0;

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.vars_tax = REG.vars_tax((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
prox = prox((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);

SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [SPEC.dates==1949 SPEC.dates==2008 ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

clevel      = [95 90 99]; 


% A. Total Market Income
REG.vars_inc    = AINC(:,[2 2:end]);
REG.vars_inc    = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
XINC            = REG.vars_inc;

for j = 1:size(REG.vars_tax,2)
VARI            = SPEC;
VARI.vars(:,1)  = REG.vars_tax(:,j);
VARI.vars(:,end)= REG.vars_inc(:,j);
VARI.taxshocks  = prox(:,j);
VARI.irhor      = 2;
VARI            = doProxySVAR(VARI);
VARIci          = doProxySVARci(VARI,clevel,3);
do_table_results
end
doTable(SVAR1,SVAR2,'SVAR using Selected Tax Reforms as Proxy: Total Market Income ',2)

% B. Wage Income  
WINC            = xlsread('data/DATA_MMO.xlsx','LOG AVG WINC');
REG.vars_inc    = WINC(:,[2 2:end]);
REG.vars_inc    = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
for j = 1:size(REG.vars_tax,2)
VARI            = SPEC;
VARI.vars(:,1)  = REG.vars_tax(:,j);
VARI.vars(:,end)= REG.vars_inc(:,j);
VARI.vars       = [VARI.vars(:,1) VARI.vars(:,2:end-1) XINC(:,j) VARI.vars(:,end)];
VARI.taxshocks  = prox(:,j);
VARI.irhor      = 2;
VARI            = doProxySVAR(VARI);
VARIci          = doProxySVARci(VARI,clevel,3);
do_table_results
end
doTable(SVAR1,SVAR2,'SVAR using Selected Tax Reforms as Proxy: Wage Income ',2)

% C. Other Income (excl. Capital Gains) 
OTHINC          = xlsread('data/DATA_MMO.xlsx','LOG AVG OTH INC');
REG.vars_inc    = OTHINC(:,[2 2:end]);
REG.vars_inc    = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
for j = 1:size(REG.vars_tax,2)
VARI            = SPEC;
VARI.vars(:,1)  = REG.vars_tax(:,j);
VARI.vars(:,end)= REG.vars_inc(:,j);
VARI.vars       = [VARI.vars(:,1) VARI.vars(:,2:end-1) XINC(:,j) VARI.vars(:,end)];
VARI.taxshocks  = prox(:,j);
VARI.irhor      = 2;
VARI            = doProxySVAR(VARI);
VARIci          = doProxySVARci(VARI,clevel,3);
do_table_results
end
doTable(SVAR1,SVAR2,'SVAR using Selected Tax Reforms as Proxy: Other Income (excl. Capital Gains) ',2)

% D. Total Market Income (Including Capital Gains) 
AINC_CG         = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME (with CG)');
REG.vars_inc    = AINC_CG(:,[2 2:end]);
REG.vars_inc    = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
for j = 1:size(REG.vars_tax,2)
VARI            = SPEC;
VARI.vars(:,1)  = REG.vars_tax(:,j);
VARI.vars(:,end)= REG.vars_inc(:,j);
VARI.vars       = [VARI.vars(:,1) VARI.vars(:,2:end-1) XINC(:,j) VARI.vars(:,end)];
VARI.taxshocks  = prox(:,j);
VARI.irhor      = 2;
VARI            = doProxySVAR(VARI);
VARIci          = doProxySVARci(VARI,clevel,3);
do_table_results
end
doTable(SVAR1,SVAR2,'SVAR using Selected Tax Reforms as Proxy: Total Market Income (including Capital Gains) ',2)

% E. Other Income (incl. Capital Gains) 
OTHINC_CG       = xlsread('data/DATA_MMO.xlsx','LOG AVG OTH INC (with CG)');
REG.vars_inc    = OTHINC_CG(:,[2 2:end]);
REG.vars_inc    = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
for j = 1:size(REG.vars_tax,2)
VARI            = SPEC;
VARI.vars(:,1)  = REG.vars_tax(:,j);
VARI.vars(:,end)= REG.vars_inc(:,j);
VARI.vars       = [VARI.vars(:,1) VARI.vars(:,2:end-1) XINC(:,j) VARI.vars(:,end)];
VARI.taxshocks  = prox(:,j);
VARI.irhor      = 2;
VARI            = doProxySVAR(VARI);
VARIci          = doProxySVARci(VARI,clevel,3);
do_table_results
end
doTable(SVAR1,SVAR2,'SVAR using Selected Tax Reforms as Proxy: Other Income (incl. Capital Gains) ',2)
