%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Table II
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation',...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

REG.vars_tax        = -log(1-AMTR(:,2:end));
REG.vars_inc        =  AINC(:,[2 2:end]);
ALLTAXCHANGES1 = xlsread('data/DATA_MMO.xlsx','AMIITR stat changes (Figure IV)');
ALLTAXCHANGES2 = xlsread('data/DATA_MMO.xlsx','AMPTR stat changes (Figure IV)');  

ALL_II_mtr     = [ALLTAXCHANGES1(:,2:10)*100];
ALL_PT_mtr     = [ALLTAXCHANGES2(:,2:10)*100];
ALL_II_mtr(isnan(ALL_II_mtr))=0;
ALL_PT_mtr(isnan(ALL_PT_mtr))=0;
ALL_mtr = ALL_II_mtr+ALL_PT_mtr;
REG.INS      = ALL_II_mtr+ALL_PT_mtr;


% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.vars_tax = REG.vars_tax((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.vars_inc = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.INS      = REG.INS((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [SPEC.dates==1949 SPEC.dates==2008 ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

[OLS1,OLS2,OLSC1,OLSC2,IVALLC1,IVALLC2]= doRegressions(SPEC,REG);

for nn = 1:size(REG.vars_inc,2)
LPIV             = SPEC;
LPIV.vars(:,1)   = REG.vars_tax(:,nn);
LPIV.vars(:,end) = REG.vars_inc(:,nn);
LPIV.taxshocks   = REG.INS(:,nn);
LPIV             = doLPIV(LPIV);
LPIVci           = doLPIVci(LPIV,95,0);
IVALLC1.Fstat_check(1,nn) = LPIVci.fstage_ivreg2;
IVALLC1.Fstat_mmo(1,nn) = LPIVci.fstage_MMO;
end
 
doTable(OLS1,OLS2,'A. OLS no Controls',0)
doTable(OLSC1,OLSC2,'B. OLS with Controls',0)
doTable(IVALLC1,IVALLC2,'C. 2SLS with Controls and Statutory Tax Changes as Instrument',1)
% Panel D is identical to Panel A in Table V

