%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Table I
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Load Data
AMTR       = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
AMIITR     = xlsread('data/DATA_MMO.xlsx','AMIITR (Figure II)'); 
AMPTR      = xlsread('data/DATA_MMO.xlsx','AMPTR (Figure III)'); 
ALLTAXCHANGES1 = xlsread('data/DATA_MMO.xlsx','AMIITR stat changes (Figure IV)');
ALLTAXCHANGES2 = xlsread('data/DATA_MMO.xlsx','AMPTR stat changes (Figure IV)');  

ALL_II_mtr     = [ALLTAXCHANGES1(:,2:10)*100];
ALL_PT_mtr     = [ALLTAXCHANGES2(:,2:10)*100];
ALL_II_mtr(isnan(ALL_II_mtr))=0;
ALL_PT_mtr(isnan(ALL_PT_mtr))=0;
ALL_mtr = ALL_II_mtr+ALL_PT_mtr;

% Descriptive Stats
    sel=isnan(AMTR(:,2))==0;
    CCORR =corr(diff(log(1-AMTR(sel,[2:10]))));

    % Variance contributions
    for j = 1:9
    Y = diff(log(1-AMTR(:,j+1)));
    X1 = ALL_II_mtr(2:end,j);
    X2 = ALL_PT_mtr(2:end,j);
    c  = ones(length(Y),1);

    b1 = [c X1]\Y;
    Y1hat =[c X1]*b1;
    res1  = (Y-Y1hat);

    b2 = [c X2]\Y;
    Y2hat =[c X2]*b2;
    res2  = (Y-Y2hat);

    b3 = [c X1+X2]\Y;
    Y3hat =[c X1+X2]*b3;
    res3  = (Y-Y3hat);

    R2(j,:) = [(Y1hat'*Y1hat-mean(Y)^2)/(Y'*Y-mean(Y)^2) (Y2hat'*Y2hat-mean(Y)^2)/(Y'*Y-mean(Y)^2) (Y3hat'*Y3hat-mean(Y)^2)/(Y'*Y-mean(Y)^2)];
    end


x=[mean(AMTR(sel,[2:10]))'*100  std(AMTR(sel,[2:10])*100)'  std(diff(log(1-AMTR(sel,[2:10])))*100)' CCORR(:,[2 3 5 8 9]) R2];
fprintf('%6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f & %6.2f \\\\\n',x');

