%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figures XI and XII
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
NARR(isnan(NARR))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,4)) -log(1-AMTR(:,9)) CONTROLS(:,2:8) AINC(:,3) AINC(:,8) NARR(:,7) NARR(:,12)]; 
DATASET.LABEL   = {'DATES','LNAMTRTOP1','LNAMTRB99','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINCTOP1','AINCB99','PROX_mtrTOP1','PROX_mtrB99'};
DATASET.UNIT    = [0         1             1          1        2      2       2      1         1        1       1        1             2           2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) Top 1% Tax Units','1/(1-AMTR) Btm 99% Tax Units','Real GDP','Unemployment Rate','Inflation',...
    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income Top 1% Tax Units','Income Btm 99% Tax Units','AMTR T1 proxy','AMTR B99 proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
ttrend               = (SPEC.sb:SPEC.se)'/1000;                      
SPEC.DET             = [ttrend ttrend.^2  SPEC.dates==1949 SPEC.dates==2008 ...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTRTOP1','LNAMTRB99','AINCTOP1','AINCB99','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX_mtrTOP1','PROX_mtrB99'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
SVARIVci            = doProxySVARci(SVARIV,clevel,3);

% Make plots
plotdisplay = {'LNAMTRTOP1','LNAMTRB99','RGDP','UNRATE','AINCTOP1','AINCB99'};

AXES        = [ -2.5 4.5; -2 2 ; -1.5 2.5 ; -0.8 0.6; -10 5; -5 5];

    % Figure XI
    shock = 1;
    name  = 'FigureXI';
    doFigure11

    % Figure XII
    shock = 4;
    name  = 'FigureXII';
    doFigure11


