%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure X
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
NARR(isnan(NARR))   = 0;
TOTINC              = NARR(:,14);

PROX_II_liab_marg      = NARR(:,2)*1000./lagmatrix(TOTINC,1);
PROX_II_liab_other     = NARR(:,3)*1000./lagmatrix(TOTINC,1);
PROX_PR_liab_marg      = NARR(:,4)*1000./lagmatrix(TOTINC,1);
PROX_PR_liab_other     = NARR(:,5)*1000./lagmatrix(TOTINC,1);
PROX_II_mtr            = NARR(:,6);
PROX_liab_marg         = PROX_II_liab_marg+PROX_PR_liab_marg;
PROX_liab_other        = PROX_II_liab_other+PROX_PR_liab_other;
PROX_II_liab_total     = PROX_II_liab_marg +PROX_II_liab_other;
PROX_liab_total        = PROX_liab_marg +PROX_liab_other;



DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,9) CONTROLS(:,2:8) AINC(:,2) PROX_II_mtr PROX_liab_total]; 
DATASET.LABEL   = {'DATES','LNAMTR1','LNAVTAX','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX_mtr','PROX_liab_total'};
DATASET.UNIT    = [0         1         1        1        2      2       2      1         1        1       1     2           2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Average Tax Rate','Real GDP','Unemployment Rate','Inflation',...
    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy','ATR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [SPEC.dates==1949 SPEC.dates==2008 ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','LNAVTAX','UNRATE','RGDP','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX_mtr','PROX_liab_total'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
SVARIVci            = doProxySVARci(SVARIV,clevel,3);

% Make plots
plotdisplay = {'LNAMTR1','LNAVTAX','AINC'};

    %Panel A
    shock = 2;
    name = 'FigureX_panelA_';
    ax = [-1.5 -3 -1.5 -1; 1 3.5 4.5 1];
    doFigure10

    %Panel B
    shock = 1;
    name = 'FigureX_panelB_';
    ax = [-1.5 -3 -1.5 -1; 1 3.5 4.5 1];
    doFigure10

    %Panel C
    shock = 4;
    name = 'FigureX_panelC_';
    ax = [-1.5 -1.5 -1.5 -1; 1 1 1 1];
    doFigure10



