%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure VII (Left Panel)
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation', ...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

REG.vars_tax        = -log(1-AMTR(:,2:end));
REG.vars_inc        =  AINC(:,[2 2:end]);
prox                = NARR(:,[6 6:13]);
prox(isnan(prox))   = 0;

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.vars_tax         = REG.vars_tax((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
REG.vars_inc         = REG.vars_inc((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
prox                 = prox((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [SPEC.dates==1949 SPEC.dates==2008 ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables = {'LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimation 
VARI= [];
irs = [];
for j = 1:size(REG.vars_tax,2)
VARI             = SPEC;
VARI.vars(:,1)   = REG.vars_tax(:,j);
VARI.vars(:,end) = REG.vars_inc(:,j);
VARI.taxshocks   = prox(:,j);
VARI.irhor       = 6;
VARI             = doProxySVAR(VARI);
IRS(:,j)         = VARI.irs(:,end);
end

% Make Plot
name = 'FigureVII_left';
irs = IRS(:,3:end);
f=figure;    
for j = [1:size(irs,2)];
X1  = 0:SPEC.irhor-1;
Y1  = irs(:,j);
    if j == 1
    p1=plot(X1,Y1,'-','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 2
    p2=plot(X1,Y1,'--','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 3
    p3=plot(X1,Y1,'-.','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 4
    p4=plot(X1,Y1,':','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    elseif j == 5
    p5=plot(X1,Y1,'-o','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on
    elseif j == 6
    p6=plot(X1,Y1,'--s','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    elseif j == 7
    p7=plot(X1,Y1,':d','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    end
end
l=columnlegend(2,{'Top 1%','Top 5%','Top 10%','Top 5% to 1%','Top 10% to 5%','Bottom 99%','Bottom 90%'},'Location','NorthWest');

xl=xlabel('horizon (years)');
yl=ylabel('percent');
set(gca,'XTick',0:1:10)
ti=title('SVAR-IV');                         
set([xl,yl], 'FontName', 'AvantGarde','FontSize',14);
set([ti], 'FontName', 'AvantGarde','FontSize',16);
axis([0 SPEC.irhor-1 -0.25 2.5])
hline(0,'k-')
str=strcat('figures/',name);
saveas(gcf,str,'epsc');








