%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure V
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation', ...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

AMTR        = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS    = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC        = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR        = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX        = NARR(:,6);
PROX(isnan(PROX)) = 0;




% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [SPEC.dates==1949 SPEC.dates==2008 ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','AINC','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
SVARIVci            = doProxySVARci(SVARIV,clevel,3);

% Make Plot 
name = 'FigureV';
plotdisplay = {'LNAMTR1','RGDP','UNRATE','AINC'};


display1= cell2mat(values(SVARIV.MAP,plotdisplay));

for nvar = 1:length(display1)
                  
        f=figure;    
        box on
        hold on
            plot(0:SVARIV.irhor-1,SVARIV.irs(:,display1(nvar)),'-','MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);
         
            if isempty(SVARIVci)==0
                if isempty(SVARIVci.irsH)==0
                p1=plot(0:SVARIV.irhor-1,SVARIVci.irsH(:,display1(nvar),1),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');
                plot(0:SVARIV.irhor-1,SVARIVci.irsL(:,display1(nvar),1),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');
                end
                if size(SVARIVci.irsH,3)>1
                p2=plot(0:SVARIV.irhor-1,SVARIVci.irsH(:,display1(nvar),2),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');
                plot(0:SVARIV.irhor-1,SVARIVci.irsL(:,display1(nvar),2),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            
            hline(0,'k-')
            ti=title( DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{plotdisplay{nvar}}))});
            xl=xlabel('horizon (years)');
            if DATASET.UNIT(cell2mat(values(DATASET.MAP,{plotdisplay{nvar}})))==1
            yl=ylabel('percent');
            elseif DATASET.UNIT(cell2mat(values(DATASET.MAP,{plotdisplay{nvar}})))==2
                yl=ylabel('percentage points');
            end
            set(gca,'XTick',0:1:10)
                         
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',14);
            set([ti], 'FontName', 'AvantGarde','FontSize',16);
            
            str=strcat('figures/',name,'_',plotdisplay{nvar});
            saveas(gcf,str,'epsc');
       
           
end



