%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure I, II and III
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

AMTR       = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
AMIITR     = xlsread('data/DATA_MMO.xlsx','AMIITR (Figure II)'); 
AMPTR      = xlsread('data/DATA_MMO.xlsx','AMPTR (Figure III)'); 

% Figure I 
%%%%%%%%%%
ax1 = [0.16 0.40];
ax2 = [0.10 0.65];
doFigure1(AMTR,ax1,ax2,1,'FigI_AMTR_','');

% Figure II
%%%%%%%%%%%
ax1 = [0.16 0.35];
ax2 = [0.10 0.65];
doFigure1(AMIITR,ax1,ax2,0,'FigII_AMIITR_',', Individual Income Tax ');

% Figure III
%%%%%%%%%%%%
ax1 = [0 0.15];
ax2 = [0 0.15];
doFigure1(AMPTR,ax1,ax2,2,'FigIII_AMPTR_',', Social Security ');
