%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure IX
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

NARR      = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
TOTINC    = NARR(:,14);

PROX_II_liab_marg      = NARR(:,2)*1000./lagmatrix(TOTINC,1);
PROX_II_liab_other     = NARR(:,3)*1000./lagmatrix(TOTINC,1);
PROX_PR_liab_marg      = NARR(:,4)*1000./lagmatrix(TOTINC,1);
PROX_PR_liab_other     = NARR(:,5)*1000./lagmatrix(TOTINC,1);
PROX_II_mtr            = NARR(:,6);
PROX_liab_marg         = PROX_II_liab_marg+PROX_PR_liab_marg;
PROX_liab_other        = PROX_II_liab_other+PROX_PR_liab_other;
PROX_II_liab_total     = PROX_II_liab_marg +PROX_II_liab_other;
PROX_liab_total        = PROX_liab_marg +PROX_liab_other;
%PROX_II_mtr_PCT        = NARR(:,7:13);

VAR.narr    = [PROX_II_mtr,PROX_liab_total];

VAR.taxshocks                = zeros(size(VAR.narr));
for j=1:2
prox_obs                     = ((isnan(VAR.narr(:,j))==0));
VAR.taxshocks(prox_obs,j)    = VAR.narr(prox_obs,j);
end

sel = isnan(VAR.narr(:,2))==0;
sel1= VAR.taxshocks(:,1)~=0;
sel2= sel&sel1==0;
labels = {'RA 1948';'';'RA 1964'; ''; '';''; 'RA 1978';'ERTA 1981';...
    '';''; '';'TRA 1986';'';'OBRA 1990';'OBRA 1993';'JGTRRA 2003'};
shift  = [ 0  -1 0 1 1 1 0 0 1 1 1 0 1 0 0 0];
f1=scatter(VAR.taxshocks(sel1,2)*100,VAR.taxshocks(sel1,1));
hold on 
f2=scatter(VAR.taxshocks(sel2,2)*100,VAR.taxshocks(sel2,1),'x');
Xx = VAR.taxshocks(sel,2);
Yy = VAR.taxshocks(sel,1);
Xgrid = (-3.5:1.5)';
bols =[Xx*100 ones(length(Xx),1)]\Yy; 
f3=plot(Xgrid,[bols(1)*Xgrid+bols(2)],'k');
f4=plot(Xgrid,[Xgrid],'k--');
text(VAR.taxshocks(sel,2)*100+0.05,VAR.taxshocks(sel,1)+shift'/10,labels)
text(-3.25,0,'Correlation: 0.90 ')
xl=xlabel('ATR proxy ');
yl=ylabel('AMTR proxy');
l=legend([f1,f2,f3,f4],'Reforms with AMTR impact','Reforms without AMTR impact','OLS regression line','45 degree line');
set(l,'Location','NorthWest')
set([xl,yl], 'FontName', 'AvantGarde');
   set([l], 'FontName', 'AvantGarde','Box','Off');
str=strcat('figures\','FigureIX');
        saveas(gcf,str,'epsc');




