%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Figure IV
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

AMTR       = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
AMIITR     = xlsread('data/DATA_MMO.xlsx','AMIITR (Figure II)'); 
AMPTR      = xlsread('data/DATA_MMO.xlsx','AMPTR (Figure III)'); 

ALLTAXCHANGES1 = xlsread('data/DATA_MMO.xlsx','AMIITR stat changes (Figure IV)');
ALLTAXCHANGES2 = xlsread('data/DATA_MMO.xlsx','AMPTR stat changes (Figure IV)');  

ALL_II_mtr     = [ALLTAXCHANGES1(:,2:10)*100];
ALL_PT_mtr     = [ALLTAXCHANGES2(:,2:10)*100];

ALL_II_mtr(isnan(ALL_II_mtr))=0;
ALL_PT_mtr(isnan(ALL_PT_mtr))=0;
ALL_mtr = ALL_II_mtr+ALL_PT_mtr;



f = figure;
box on
l2= bar(AMIITR(:,1),ALL_II_mtr(:,2));
set(l2,'EdgeColor',[0 0 0.5],'FaceColor',[0.7 0.7 0.7])
hold on 
l1= plot(AMIITR(:,1),[0;diff(AMIITR(:,2))*100],'Linewidth',2,'Color', [0 0 0.5]);
hold on 
hline(0,'k')
yl=ylabel('pp change');
set([yl],'FontSize',14);
ti=title('All Tax Units, Individual Income Tax');
set([ti], 'FontName', 'AvantGarde','FontWeight','bold','Fontsize',10);
set([yl], 'FontName', 'AvantGarde','Fontsize',8);
l = legend([l1 l2],'Observed Annual Change in AMTR','Impact of Statutory Changes');
set(l,'box','off')
set([l], 'FontName', 'AvantGarde','FontSize',8,'Location','SouthEast');
axis([1945 2013 -8 6])
set(gca,'XTick',1945:5:2010)

str=strcat('figures\','FigIV_','AMIITR');
saveas(f,str,'epsc');


f = figure;
box on
l2= bar(AMPTR(:,1),ALL_PT_mtr(:,2));
set(l2,'EdgeColor',[0 0 0.5],'FaceColor',[0.7 0.7 0.7])
hold on 
l1= plot(AMPTR(:,1),[0;diff(AMPTR(:,2))*100],'Linewidth',2,'Color', [0 0 0.5]);
hold on 
hline(0,'k')
yl=ylabel('pp change');
set([yl],'FontSize',14);
ti=title('All Tax Units, Social Security');
set([ti], 'FontName', 'AvantGarde','FontWeight','bold','Fontsize',10);
set([yl], 'FontName', 'AvantGarde','Fontsize',8);
l = legend([l1 l2],'Observed Annual Change in AMTR','Impact of Statutory Changes');
set(l,'box','off')
set([l], 'FontName', 'AvantGarde','FontSize',8,'Location','SouthEast');
axis([1945 2013 -1.5 1.5])
set(gca,'XTick',1945:5:2010)

% str=strcat('figures\','FigIV_','AMPTR');
% saveas(f,str,'epsc');



f = figure;
box on
l4= bar(AMPTR(:,1),[ALL_II_mtr(:,1)+ALL_PT_mtr(:,1)]);
set(l4,'EdgeColor',[0 0 0.5],'FaceColor',[0.7 0.7 0.7])
hold on 
l1= plot(AMPTR(:,1),[0;diff(AMTR(:,2))*100],'Linewidth',2,'Color', [0 0 0.5]);
hold on 
hline(0,'k')
yl=ylabel('pp change');
set([yl],'FontSize',14);
ti=title('All Tax Units');
set([ti], 'FontName', 'AvantGarde','FontWeight','bold','Fontsize',10);
set([yl], 'FontName', 'AvantGarde','Fontsize',8);
l = legend([l1 l2(1)],'Observed Annual Change in AMTR','Impact of Statutory Changes');
set(l,'box','off')
set([l], 'FontName', 'AvantGarde','FontSize',8,'Location','SouthEast');
axis([1945 2013 -8 6])
set(gca,'XTick',1945:5:2010)

% str=strcat('figures\','FigIV_','ALL');
% saveas(f,str,'epsc');

