%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Table B.IV
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation',...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [detrend(SPEC.dates==1949,'constant') detrend(SPEC.dates==2008,'constant')...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

clevel      = [95 90 99];   % Bootstrap Percentiles
method = 1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Panel A
% Load Data
NARRexcl.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel A'); 
NARRexcl.TSERIES = NARRexcl.TSERIES(:,2:end);
NARRexcl.LABEL   = {'excl_RA1948','excl_RA1964','excl_RA1978','excl_ERTA81','excl_TRA86','excl_81_and_86','excl_OBRA90','excl_OBRA93','excl_JGTRRA03'};

for j = 1:size(NARRexcl.TSERIES,2)
LPIV        = SPEC;    
LPIV.taxshocks = NARRexcl.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
LPIV         = doLPIV(LPIV); 
LPIVci       = doLPIVci(LPIV,clevel,method);
LPIV1.b(1,j) = LPIV.irs(1,end);
LPIV2.b(1,j) = LPIV.irs(2,end);
LPIV1.CI95(:,j)=[LPIVci.irsL(1,end,1);LPIVci.irsH(1,end,1)];
LPIV1.CI90(:,j)=[LPIVci.irsL(1,end,2);LPIVci.irsH(1,end,2)];
LPIV1.CI99(:,j)=[LPIVci.irsL(1,end,3);LPIVci.irsH(1,end,3)];
LPIV2.CI95(:,j)=[LPIVci.irsL(2,end,1);LPIVci.irsH(2,end,1)];
LPIV2.CI90(:,j)=[LPIVci.irsL(2,end,2);LPIVci.irsH(2,end,2)];
LPIV2.CI99(:,j)=[LPIVci.irsL(2,end,3);LPIVci.irsH(2,end,3)];
LPIV1.Fstat(1,j)     = LPIVci.fstage_ivreg2;
LPIV1.Fstat_mmo(1,j) = LPIVci.fstage_MMO;
end
doTable(LPIV1,LPIV2,'A. Omitting Tax Reforms',1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Panel B
LPIV1 = []; LPIV2=[];
laglength=[1 3];
ttrend=(1946:2012)'-1946;

for j = 1:9
LPIV         = SPEC;
    if (j == 1)|| (j == 2)   
        if LPIV.dates(1)+laglength(j)>1949
            LPIV.DET     = [LPIV.dates==2008 ones(size(TSERIES,1),1)]; 
        end
        LPIV.p        = laglength(j);
    elseif j==3
         LPIV.DET    = [LPIV.dates==2008 ones(size(TSERIES,1),1)];
    elseif j==4
         LPIV.DET     = [LPIV.dates==1949 ones(size(TSERIES,1),1)]; 
    elseif j==5
        sel = (LPIV.dates>=1948)&(LPIV.dates<=2012);
        LPIV.DET    = [LPIV.dates==2008 ones(size(TSERIES,1),1)];
        LPIV.DET = LPIV.DET(sel,:);
        LPIV.vars = LPIV.vars(sel,:);
        LPIV.taxshocks = LPIV.taxshocks(sel,:);
    elseif j==6
        sel = (LPIV.dates>=1948)&(LPIV.dates<=2006);
        LPIV.DET    = [ones(size(TSERIES,1),1)];
        LPIV.DET = LPIV.DET(sel,:);
        LPIV.vars = LPIV.vars(sel,:);
        LPIV.taxshocks = LPIV.taxshocks(sel,:);
    elseif j==7
        sel = (LPIV.dates>=1958)&(LPIV.dates<=2000);
        LPIV.DET    = [ones(size(TSERIES,1),1)];
        LPIV.DET = LPIV.DET(sel,:);
        LPIV.vars = LPIV.vars(sel,:);
        LPIV.taxshocks = LPIV.taxshocks(sel,:);
    elseif j==8
        LPIV.DET     = [ttrend (ttrend).^2  LPIV.DET];         % Deterministic Terms (Put constant last) 
    elseif j==9
        LPIV.DET     = [ttrend (ttrend).^2 (ttrend).^3 LPIV.DET];         % Deterministic Terms (Put constant last)        
    end
    
LPIV         = doLPIV(LPIV); 
LPIVci       = doLPIVci(LPIV,clevel,method);
LPIV1.b(1,j) = LPIV.irs(1,end);
LPIV2.b(1,j) = LPIV.irs(2,end);
LPIV1.CI95(:,j)=[LPIVci.irsL(1,end,1);LPIVci.irsH(1,end,1)];
LPIV1.CI90(:,j)=[LPIVci.irsL(1,end,2);LPIVci.irsH(1,end,2)];
LPIV1.CI99(:,j)=[LPIVci.irsL(1,end,3);LPIVci.irsH(1,end,3)];
LPIV2.CI95(:,j)=[LPIVci.irsL(2,end,1);LPIVci.irsH(2,end,1)];
LPIV2.CI90(:,j)=[LPIVci.irsL(2,end,2);LPIVci.irsH(2,end,2)];
LPIV2.CI99(:,j)=[LPIVci.irsL(2,end,3);LPIVci.irsH(2,end,3)];
LPIV1.Fstat(1,j)     = LPIVci.fstage_ivreg2;
LPIV1.Fstat_mmo(1,j) = LPIVci.fstage_MMO;

end 

doTable(LPIV1,LPIV2,'B. Alternative Specifications and Samples',1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Panel C
TR.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel C'); 
TR.TSERIES = TR.TSERIES(:,2:end);
TR.LABEL   = {'LNAMTR2','LNAMIITR1','LNAMIITR2','PROX_liab_marg','PROX_liab_total'};

LPIV1 = []; LPIV2=[];
for j =1:5
LPIV         = SPEC;
    if (j==1)||(j==2)||(j==3)
        LPIV.vars(:,1) = TR.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
    elseif (j==4)||(j==5)
        LPIV.taxshocks = TR.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
    end
LPIV         = doLPIV(LPIV); 
LPIVci       = doLPIVci(LPIV,clevel,method);
LPIV1.b(1,j) = LPIV.irs(1,end);
LPIV2.b(1,j) = LPIV.irs(2,end);
LPIV1.CI95(:,j)=[LPIVci.irsL(1,end,1);LPIVci.irsH(1,end,1)];
LPIV1.CI90(:,j)=[LPIVci.irsL(1,end,2);LPIVci.irsH(1,end,2)];
LPIV1.CI99(:,j)=[LPIVci.irsL(1,end,3);LPIVci.irsH(1,end,3)];
LPIV2.CI95(:,j)=[LPIVci.irsL(2,end,1);LPIVci.irsH(2,end,1)];
LPIV2.CI90(:,j)=[LPIVci.irsL(2,end,2);LPIVci.irsH(2,end,2)];
LPIV2.CI99(:,j)=[LPIVci.irsL(2,end,3);LPIVci.irsH(2,end,3)];
LPIV1.Fstat(1,j)     = LPIVci.fstage_ivreg2;
LPIV1.Fstat_mmo(1,j) = LPIVci.fstage_MMO;
end
doTable(LPIV1,LPIV2,'C.  Alternative Tax Rate Measures and Proxies',1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Panel D
XY.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel D'); 
XY.TSERIES = XY.TSERIES(:,2:end);
XY.LABEL   = {'CAPG','RAMEYNEWS','BAA','EDUC','LNFPART','TOP10SHARE','GINI','WGINEQ','LNACITR','CINARR'};

LPIV1 = []; LPIV2=[];

for j = 1:8
LPIV         = SPEC;
LPIV.vars = [LPIV.vars(:,1) XY.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j) LPIV.vars(:,2:end)];
        if (j==4)||(j==7)
        sel = (LPIV.dates>=1947)&(LPIV.dates<=2012);
        LPIV.DET = LPIV.DET(sel,:);
        LPIV.vars = LPIV.vars(sel,:);
        LPIV.taxshocks = LPIV.taxshocks(sel,:);
        elseif j==9
        LPIV.taxshocks = [LPIV.taxshocks XY.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),10)];
        end
LPIV         = doLPIV(LPIV); 
LPIVci       = doLPIVci(LPIV,clevel,method);
        if j ==9
         LPIV.irs(:,:,[2:4]) = [];
         LPIVci.irsH(:,:,:,[2:4]) = [];
         LPIVci.irsL(:,:,:,[2:4]) = [];
         LPIVci.Waldstat = NaN;
        end
LPIV1.b(1,j) = LPIV.irs(1,end);
LPIV2.b(1,j) = LPIV.irs(2,end);
LPIV1.CI95(:,j)=[LPIVci.irsL(1,end,1);LPIVci.irsH(1,end,1)];
LPIV1.CI90(:,j)=[LPIVci.irsL(1,end,2);LPIVci.irsH(1,end,2)];
LPIV1.CI99(:,j)=[LPIVci.irsL(1,end,3);LPIVci.irsH(1,end,3)];
LPIV2.CI95(:,j)=[LPIVci.irsL(2,end,1);LPIVci.irsH(2,end,1)];
LPIV2.CI90(:,j)=[LPIVci.irsL(2,end,2);LPIVci.irsH(2,end,2)];
LPIV2.CI99(:,j)=[LPIVci.irsL(2,end,3);LPIVci.irsH(2,end,3)];
LPIV1.Fstat(1,j)     = LPIVci.fstage_ivreg2;
LPIV1.Fstat_mmo(1,j) = LPIVci.fstage_MMO;
end
doTable(LPIV1,LPIV2,'D.  Additional Controls',1)


