%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates Table B.III
%
% Karel Mertens and Jose Montiel-Olea, ``Marginal Tax Rates and Income, 
%                                    New Time Series Evidence''
% January, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

% Load Data
AMTR                = xlsread('data/DATA_MMO.xlsx','AMTR (Figure I)'); 
CONTROLS            = xlsread('data/DATA_MMO.xlsx','CONTROLS');
AINC                = xlsread('data/DATA_MMO.xlsx','LOG AVG INCOME');
NARR                = xlsread('data/DATA_MMO.xlsx','Narrative Shocks (Table IV)'); 
PROX                = NARR(:,6);
PROX(isnan(PROX))   = 0;

DATASET.TSERIES = [AMTR(:,1) -log(1-AMTR(:,2)) CONTROLS(:,2:8) AINC(:,2) PROX]; 
DATASET.LABEL   = {'DATES','LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC','PROX'};
DATASET.UNIT    = [0         1         1        2      2      2      1         1        1       1     2 ]; 
DATASET.FIGLABELS= [{'year' ,'1/(1-AMTR) All Tax Units','Real GDP','Unemployment Rate','Inflation',...
                    'Federal Funds Rate','Government Spending','Real Stock Prices', 'Debt','Income (All Tax Units)','AMTR proxy'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1946;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [detrend(SPEC.dates==1949,'constant') detrend(SPEC.dates==2008,'constant')...
                            ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 6; % Length of IR horizon 
SPEC.select_variables= {'LNAMTR1','RGDP','UNRATE','INFL','FFR','GOV_TOT','STPRICE','DEBT','AINC'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   


clevel      = [95 90 99];   
method      = 3;
% Panel A
NARRexcl.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel A'); 
NARRexcl.TSERIES = NARRexcl.TSERIES(:,2:end);
NARRexcl.LABEL   = {'excl_RA1948','excl_RA1964','excl_RA1978','excl_ERTA81','excl_TRA86','excl_81_and_86','excl_OBRA90','excl_OBRA93','excl_JGTRRA03'};
for j = 1:size(NARRexcl.TSERIES,2)
VARI            = SPEC;    
VARI.taxshocks  = NARRexcl.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
VARI            = doProxySVAR(VARI); 
VARIci          = doProxySVARci(VARI,clevel,method);
do_table_results
end
doTable(SVAR1,SVAR2,'A. Omitting Tax Reforms',2)

% Panel B
SVAR1 = []; SVAR2=[];
laglength=[1 3];
ttrend=(1946:2012)'-1946;
warning off 
for j = 1:9
VARI         = SPEC;
    if (j == 1)|| (j == 2)   
        if VARI.dates(1)+laglength(j)>1949
            VARI.DET     = [VARI.dates==2008 ones(size(TSERIES,1),1)]; 
        end
        VARI.p        = laglength(j);
    elseif j==3
         VARI.DET    = [VARI.dates==2008 ones(size(TSERIES,1),1)];
    elseif j==4
         VARI.DET     = [VARI.dates==1949 ones(size(TSERIES,1),1)]; 
    elseif j==5
        sel = (VARI.dates>=1948)&(VARI.dates<=2012);
        VARI.DET    = [VARI.dates==2008 ones(size(TSERIES,1),1)];
        VARI.DET = VARI.DET(sel,:);
        VARI.vars = VARI.vars(sel,:);
        VARI.taxshocks = VARI.taxshocks(sel,:);
    elseif j==6
        sel = (VARI.dates>=1948)&(VARI.dates<=2006);
        VARI.DET    = [ones(size(TSERIES,1),1)];
        VARI.DET = VARI.DET(sel,:);
        VARI.vars = VARI.vars(sel,:);
        VARI.taxshocks = VARI.taxshocks(sel,:);
    elseif j==7
        sel = (VARI.dates>=1958)&(VARI.dates<=2000);
        VARI.DET    = [ones(size(TSERIES,1),1)];
        VARI.DET = VARI.DET(sel,:);
        VARI.vars = VARI.vars(sel,:);
        VARI.taxshocks = VARI.taxshocks(sel,:);
    elseif j==8
        VARI.DET     = [ttrend (ttrend).^2  VARI.DET];         % Deterministic Terms (Put constant last) 
    elseif j==9
        VARI.DET     = [ttrend (ttrend).^2 (ttrend).^3 VARI.DET];         % Deterministic Terms (Put constant last)        
    end
    
VARI         = doProxySVAR(VARI); 
VARIci       = doProxySVARci(VARI,clevel,method);
do_table_results
end    
doTable(SVAR1,SVAR2,'B. Alternative Specifications and Samples',2)


% Panel C
TR.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel C'); 
TR.TSERIES = TR.TSERIES(:,2:end);
TR.LABEL   = {'LNAMTR2','LNAMIITR1','LNAMIITR2','PROX_liab_marg','PROX_liab_total'};

SVAR1 = []; SVAR2=[];
for j =1:5
VARI         = SPEC;
    if (j==1)||(j==2)||(j==3)
        VARI.vars(:,1) = TR.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
    elseif (j==4)||(j==5)
        VARI.taxshocks = TR.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j);
    end
VARI         = doProxySVAR(VARI); 
VARIci       = doProxySVARci(VARI,clevel,method);
do_table_results
end
doTable(SVAR1,SVAR2,'C.  Alternative Tax Rate Measures and Proxies',2)

% Panel D
XY.TSERIES = xlsread('data/DATA_MMO_appendix.xls','panel D'); 
XY.TSERIES = XY.TSERIES(:,2:end);
XY.LABEL   = {'CAPG','RAMEYNEWS','BAA','EDUC','LNFPART','TOP10SHARE','GINI','WGINEQ','LNACITR','CINARR'};

SVAR1 = []; SVAR2=[];

for j = 1:9
VARI         = SPEC;
VARI.vars = [VARI.vars(:,1) XY.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),j) VARI.vars(:,2:end)];
        if (j==4)||(j==7)
        sel = (VARI.dates>=1947)&(VARI.dates<=2012);
        VARI.DET = VARI.DET(sel,:);
        VARI.vars = VARI.vars(sel,:);
        VARI.taxshocks = VARI.taxshocks(sel,:);
        elseif j==9
        VARI.taxshocks = [VARI.taxshocks XY.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),10)];
        end
VARI         = doProxySVAR(VARI); 
if j == 9
    method = 1;
end
VARIci       = doProxySVARci(VARI,clevel,method,1000);
        if j ==9
         VARI.irs(:,:,[2:4]) = [];
         VARIci.irsH(:,:,:,[2:4]) = [];
         VARIci.irsL(:,:,:,[2:4]) = [];
         VARIci.Waldstat = NaN;
        end
do_table_results
end
doTable(SVAR1,SVAR2,'D.  Additional Controls',2)




