function plot_irs_mon(IRS1,IRS2,FIG,varargin)

tt  = 1:FIG.stplot(2);
sel = tt>=FIG.stplot(1);

shocksize = -10.1;
IRS2 = IRS2*shocksize;

figure
    box off
        hold on
        if FIG.fill ==1 
        X =[tt(sel)+FIG.shift(2),fliplr(tt(sel)+FIG.shift(2))];                
        Y =[IRS2(sel,4)',fliplr(IRS2(sel,5)')];
        hh=fill(X,Y,[0.9 0 0]); 
        set(hh,'facealpha',.2,'edgecolor','white')
        else
        plot(FIG.shift(1)+tt(sel),IRS2(sel,4),'LineWidth',1,'Color',[0.9 0 0],'LineStyle','-.' ); 
        plot(FIG.shift(1)+tt(sel),IRS2(sel,5),'LineWidth',1,'Color',[0.9 0 0],'LineStyle','-.' );    
        end
   
        plot(FIG.shift(1)+tt(sel),IRS1(sel,4),'LineWidth',1,'Color',[0 0 0.5] ); 
        plot(FIG.shift(1)+tt(sel),IRS1(sel,5),'LineWidth',1,'Color',[0 0 0.5] );         
     p1=plot(FIG.shift(1)+tt(sel),IRS1(sel,1),'LineWidth',2,'Color',[0 0 0.5] );
     p2=plot(FIG.shift(2)+tt(sel),IRS2(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','-.' );

        axis([min(tt)-1 max(tt)+1+FIG.shift(2) -inf inf])
  
        hline(0,'k-')
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        if FIG.units==1
        yl=ylabel('percent');
        elseif FIG.units==2
        yl=ylabel('basis points');
        elseif FIG.units==3
        yl=ylabel('dollars');
        end
        set(gca,'XTick',[0:6:48])
        
        l=legend([p1 p2],FIG.legend{1},FIG.legend{2});
        if isempty(varargin)
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthWest');
        elseif varargin{1}==0  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthWest');
        elseif varargin{1}==1  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthEast');
        elseif varargin{1}==2  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthWest');
        elseif varargin{1}==3  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthEast');
        end
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12);        
        set(gca,'LooseInset',get(gca,'TightInset'))
       
       str=strcat('figures/',FIG.name);
       saveas(gcf,str,'epsc');