function plot_irs(IRS,FIG)

tt  = 1:FIG.stplot(2);
sel = tt>=FIG.stplot(1);


figure
    box off
        hold on
        if FIG.fill ==1 
        X =[tt(sel)+FIG.shift(2),fliplr(tt(sel)+FIG.shift(2))];                
        Y =[IRS(sel,8)',fliplr(IRS(sel,9)')];
        hh1=fill(X,Y,[0 0 0.5]); 
        set(hh1,'facealpha',.1,'edgecolor','white')

        X =[tt(sel)+FIG.shift(2),fliplr(tt(sel)+FIG.shift(2))];                
        Y =[IRS(sel,4)',fliplr(IRS(sel,5)')];
        hh2=fill(X,Y,[0 0 0.5]); 
        set(hh2,'facealpha',.2,'edgecolor','white')
        else
        plot(tt(sel),IRS(sel,4),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-' ); 
        plot(tt(sel),IRS(sel,5),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-' );  
        plot(tt(sel),IRS(sel,8),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        plot(tt(sel),IRS(sel,9),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        end
        plot(tt(sel),IRS(sel,1),'LineWidth',2,'Color',[0 0 0.5] );
         hline(0,'k-')
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        if FIG.units==1
        yl=ylabel('percent');
        elseif FIG.units==2
        yl=ylabel('basis points');
        elseif FIG.units==3
        yl=ylabel('dollars');
        end
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');