function VAR = doSVAR(VAR)

X      = lagmatrix(VAR.vars,1:VAR.p);
X      = X(VAR.p+1:end,:);
Y      = VAR.vars(VAR.p+1:end,:);
DET    = VAR.DET(VAR.p+1:end,:);

sel = (isnan(sum([Y X],2))==0); 
X = X(sel,:);
Y = Y(sel,:);
DET = DET(sel,:);
VAR.m  = VAR.MSHOCKS(VAR.p+1:end,:);

[VAR.T,VAR.n] = size(Y);

% A. Run VAR
%%%%%%%%%%%%
VAR.bet   = [X DET]\Y; 
VAR.res   = Y-[X DET]*VAR.bet;
VAR.Sigma = (VAR.res'*VAR.res)/(VAR.T-size(VAR.bet,1));

% Impulse Responses GSE ER shock
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 D = chol(VAR.Sigma,'lower');
 dd1             = D(:,end-2);
 irs(VAR.p+1,:) = dd1/dd1(end-2)*VAR.shocksize;
 for jj=2:VAR.irhor
 lvars = (irs(VAR.p+jj-1:-1:jj,:))';
 irs(VAR.p+jj,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);     
 end
 VAR.irs = irs(VAR.p+1:end,:); 
 VAR.irs(:,2)=   cumsum(VAR.irs(:,2));
 
% Impulse Responses Monetary shock
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%IV implementation
zt  =  VAR.res(:,5);
zex = [VAR.res(:,[1:4 6:end])];%[ VAR.res_tax VAR.res_inc];
zthat  = [ones(length(zt),1) VAR.m]*([ones(length(zt),1) VAR.m]\zt);
theta  = [ones(length(zt),1) zthat]\zex; 
resex  = zex-[ones(length(zthat),1) zt]*theta; 
zexhat = [ones(length(zt),1) resex]*([ones(length(zt),1) resex]\zex);
xi     = [ones(length(zt),1) zexhat]\zt;
rest   = zt - [ones(length(zt),1) zex]*xi;
VAR.et = rest/std(rest);


% Impulse Responses
 dd2             = (VAR.et\VAR.res)';
 irs(VAR.p+1,:) = -0.25*dd2/dd2(5);
 for jj=2:VAR.irhor
 lvars = (irs(VAR.p+jj-1:-1:jj,:))';
 irs(VAR.p+jj,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);     
 end

VAR.irsm = irs(VAR.p+1:end,:); 
VAR.irsm(:,2)=   cumsum(VAR.irsm(:,2));

 
% Forecast Error Decomposition
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FEVD_M = []; 
FEVD_M(VAR.p+1,:) = diag(dd2*dd2');
 V      = zeros(VAR.n*VAR.p,VAR.n*VAR.p);
 V(1:VAR.n,1:VAR.n)      = dd2*dd2'; 
 VV     = V;
 BET    = [VAR.bet(1:end-1,:)'; eye(VAR.n*(VAR.p-1),VAR.n*(VAR.p-1)) zeros(VAR.n*(VAR.p-1),VAR.n)];
  for tt=2:VAR.irhor
     V      = BET*V*BET'+VV; 
     FEVD_M(VAR.p+tt,:) = diag(V(1:VAR.n,1:VAR.n));   
  end 

FEVD_N = [];
FEVD_N(VAR.p+1,:) = diag(dd1*dd1');
 V      = zeros(VAR.n*VAR.p,VAR.n*VAR.p);
 V(1:VAR.n,1:VAR.n)      = dd1*dd1'; 
 VV     = V;
 BET    = [VAR.bet(1:end-1,:)'; eye(VAR.n*(VAR.p-1),VAR.n*(VAR.p-1)) zeros(VAR.n*(VAR.p-1),VAR.n)];
  for tt=2:VAR.irhor
     V      = BET*V*BET'+VV; 
     FEVD_N(VAR.p+tt,:) = diag(V(1:VAR.n,1:VAR.n));   
  end 



 FEVD_D = [];
 FEVD_D(VAR.p+1,:) = diag(VAR.Sigma);
 V      = zeros(VAR.n*VAR.p,VAR.n*VAR.p);
 V(1:VAR.n,1:VAR.n)      = VAR.Sigma; 
 VV     = V;
 BET    = [VAR.bet(1:end-1,:)'; eye(VAR.n*(VAR.p-1),VAR.n*(VAR.p-1)) zeros(VAR.n*(VAR.p-1),VAR.n)];
  for tt=2:VAR.irhor
     V      = BET*V*BET'+VV; 
     FEVD_D(VAR.p+tt,:) = diag(V(1:VAR.n,1:VAR.n));   
  end 
% 
% 
  FEVD1 = FEVD_N./FEVD_D;
  FEVD2 = FEVD_M./FEVD_D;
  VAR.FEVD1 = FEVD1(VAR.p+1:end,:); 
  VAR.FEVD2 = FEVD2(VAR.p+1:end,:); 
 
 
 
