function [IRS1,IRS3] = Estimate_irs_apcf_shock(LP)
 
hor = max(LP.hor);
dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:) ;

    % Controls 
    CC  = LP.CONTROLS;  % Lagged controls
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    try 
    CC  = [LP.CONTROLS LP.WCONTROLS];  % Lagged controls
    CONTROLS1 = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    catch
    CONTROLS1 = CONTROLS;    
    end  

    % LHS Variable
    MYY  = lagmatrix(LP.vars,0:-1:-hor)-lagmatrix(LP.vars,1)*ones(1,hor+1);
    MY  = MYY((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % RHS Variable
    PP1  = sum(lagmatrix(LP.P1,-7:0),2)/8*12./LP.SCALE;
    P1 = PP1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    % Instrumental Variable 
    ZZ1  = LP.INS1;    
    Z1 = ZZ1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
 

    MYYr = lagmatrix(LP.P2,0:-1:-hor)-lagmatrix(LP.P2,1)*ones(1,hor+1);
    MYr  = MYYr((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);  
    PP2  = LP.P2;
    P2   = PP2((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    ZZ2  = LP.INS2;  ZZ2(isnan(ZZ2))=0;
    Z2   = ZZ2((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
   
    sel = (isnan(sum([MY MYr P1 P2 Z1 Z2 CONTROLS CONTROLS1],2))==0)&(dates<=LP.se);
       
% Agency Purchase Shock
%%%%%%%%%%%%%%%%%%%%%%%   
    Xfs1   = [Z1(sel,:) CONTROLS1(sel,:)];
    betfs1 = Xfs1\P1(sel,:); 
    Phat1  = Xfs1*betfs1;
    Bya    = [Phat1 CONTROLS1(sel,:)]\MY(sel,:);
    Phi_ya = Bya(1,:)';
    XX1 = [P1(sel,:) CONTROLS1(sel,:)]; 
    [T,k]    = size(XX1);
   
    % Standard Errors
    for jj = 1:hor+1
    [~,~,Q]       = NeweyWest(MY(sel,jj)-XX1*Bya(:,jj),Xfs1,floor(4*((T/100)^(2/9))),0);
    varbet= (diag((T)*((Xfs1'*XX1)\Q/(XX1'*Xfs1))));
    SE1(jj,1) = sqrt(varbet(1,1))';
    end
    
    
% Agency Shock with constant interest rate    
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    Xfs2   = [Z2(sel,:) CONTROLS(sel,:)];
    betfs2 = Xfs2\P2(sel,:);
    Phat2  = Xfs2*betfs2;
    Byr    = [Phat2 CONTROLS(sel,:)]\MY(sel,:); 
    Brr    = [Phat2 CONTROLS(sel,:)]\MYr(sel,:);
    Phi_yr = Byr(1,:)';
    Phi_rr = Brr(1,:)';
    XX2 = [P2(sel,:) CONTROLS(sel,:)]; 
    [T,k]    = size(XX2);

    Bra    = [Phat1 CONTROLS1(sel,:)]\MYr(sel,:);
    Phi_ra = Bra(1,:)';
    
    BYR = lagmatrix(Phi_yr,0:hor);
    BYR(isnan(BYR)) = 0;
    BRR = lagmatrix(Phi_rr,0:hor);
    BRR(isnan(BRR)) = 0;

    LP.MS = -BRR\Phi_ra;  % Monetary Shock Path
    FF = BYR/BRR;
    MYd = (MY(sel,:)-MYr(sel,:)*FF');
    bb=[Phat1 CONTROLS1(sel,:)]\MYd;
    Phi_ya_diff=(bb(1,:))';

    % Standard Errors
    for jj = 1:hor+1
    [~,W,Q]       = NeweyWest(MYd(:,jj)-XX1*bb(:,jj),Xfs1,floor(4*((T/100)^(2/9))),0);
    varbet= (diag((T)*((Xfs1'*XX1)\Q/(XX1'*Xfs1))));
    SE3(jj,1) = sqrt(varbet(1,1))';
    end
    
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Agency Shock

irs      = Phi_ya;
irs10    = [irs+(tinv(0.95,T-k)*SE1) irs-(tinv(0.95,T-k)*SE1)];
irs5     = [irs+(tinv(0.975,T-k)*SE1) irs-(tinv(0.975,T-k)*SE1)];
irs1     = [irs+(tinv(0.995,T-k)*SE1) irs-(tinv(0.995,T-k)*SE1)];
irs32    = [irs+(tinv(0.84,T-k)*SE1) irs-(tinv(0.84,T-k)*SE1)];
IRS1     = [irs irs10 irs5 irs1 irs32];

% Agency Shock with constant interest rate
irs      = Phi_ya_diff;
irs10    = [irs+(tinv(0.95,T-k)*SE3) irs-(tinv(0.95,T-k)*SE3)];
irs5     = [irs+(tinv(0.975,T-k)*SE3) irs-(tinv(0.975,T-k)*SE3)];
irs1     = [irs+(tinv(0.995,T-k)*SE3) irs-(tinv(0.995,T-k)*SE3)];
irs32    = [irs+(tinv(0.84,T-k)*SE3) irs-(tinv(0.84,T-k)*SE3)];
IRS3     = [irs irs10 irs5 irs1 irs32];
