function IRS1 = Estimate_irs_ap_shock(LP,varargin)

hor = max(LP.hor);
dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:) ;

    % Controls 
    try 
    CC  = [LP.CONTROLS LP.WCONTROLS]; 
    CONTROLS1 = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    catch
    CC  = [LP.CONTROLS];  
    CONTROLS1 = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);    
    end
    
    % LHS Variable
    MYY  = lagmatrix(LP.vars,0:-1:-hor)-lagmatrix(LP.vars,1)*ones(1,hor+1);
    MY  = MYY((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % RHS Variable
    PP1  = sum(lagmatrix(LP.P1,-7:0),2)/8*12./LP.SCALE;
    P1 = PP1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    % Instrumental Variable 
    ZZ1  = LP.INS1;    
    Z1 = ZZ1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
       
    sel = (isnan(sum([MY P1 Z1 CONTROLS1],2))==0)&(dates<=LP.se);
    
    try
        s1 = LP.om1;
        s2 = LP.om2;
        MY = MY((dates<=s1)|(dates>=s2),:);
        P1 = P1((dates<=s1)|(dates>=s2),:);
        Z1 = Z1((dates<=s1)|(dates>=s2),:);
        CONTROLS1 = CONTROLS1((dates<=s1)|(dates>=s2),:);
        sel = sel((dates<=s1)|(dates>=s2),:);
    end 
     
% Agency Purchase Shock
%%%%%%%%%%%%%%%%%%%%%%%
    Xfs1    = [Z1(sel,:) CONTROLS1(sel,:)];
    betfs1  = Xfs1\P1(sel,:); 
    Phat1   = Xfs1*betfs1;
    Bya     = [Phat1 CONTROLS1(sel,:)]\MY(sel,:);
    Phi_ya  = Bya(1,:)';
    XX1     = [P1(sel,:) CONTROLS1(sel,:)]; 
    [T,k]   = size(XX1);

    if isempty(varargin)
    % Standard Errors
        for jj = 1:hor+1
        [~,~,Q]       = NeweyWest(MY(sel,jj)-XX1*Bya(:,jj),Xfs1,floor(4*((T/100)^(2/9))),0);
        varbet= (diag((T)*((Xfs1'*XX1)\Q/(XX1'*Xfs1))));
        SE1(jj,1) = sqrt(varbet(1,1))';
        end 
    end
 
irs      = Phi_ya;
if isempty(varargin)
irs10    = [irs+(tinv(0.95,T-k)*SE1) irs-(tinv(0.95,T-k)*SE1)];
irs5     = [irs+(tinv(0.975,T-k)*SE1) irs-(tinv(0.975,T-k)*SE1)];
irs1     = [irs+(tinv(0.995,T-k)*SE1) irs-(tinv(0.995,T-k)*SE1)];
irs32    = [irs+(tinv(0.84,T-k)*SE1) irs-(tinv(0.84,T-k)*SE1)];
IRS1     = [irs irs10 irs5 irs1 irs32];
else 
IRS1 = irs;
end

