function [IRS1,IRS2] = Estimate_cum_multipliers(LP,varargin)
hor = max(LP.hor);
dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % Controls   
    CC  = [LP.CONTROLS];  % Lagged controls
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);    

    % LHS Variable
    if LP.stock==1
    MYY  = (lagmatrix(LP.Y,0:-1:-hor)-lagmatrix(LP.Y,1)*ones(1,hor+1))./(LP.SCALE*ones(1,hor+1));
    elseif LP.stock==0
    MYY  = (cumsum(lagmatrix(LP.Y,0:-1:-hor),2)-lagmatrix(LP.Y,1)*ones(1,hor+1))./(LP.SCALE*ones(1,hor+1));    
    end
    MY  = MYY((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
  
    % RHS Variables
    PP1  = cumsum(lagmatrix(LP.P,0:-1:-hor),2)./(LP.SCALE*ones(1,hor+1));
    P1   = PP1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    % Instrumental Variable 
    ZZ  = LP.INS;    
    Z   = ZZ((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
      
    sel = (isnan(sum([MY P1 CONTROLS],2))==0)&(dates<=LP.se);
     
    % First Stage
    Xfs   = [Z(sel,:) CONTROLS(sel,:)];
    betfs1 = Xfs\P1(sel,:); 
    Phat1  = Xfs*betfs1;
    [T,k]    = size(Xfs);
    
    % Second Stage
    SE1  = zeros(hor+1,1);
    Bya1 = zeros(k,hor+1);
    SE1_ols  = zeros(hor+1,1);
    Bya1_ols = zeros(k,hor+1);
   
    for jj = 1:hor+1
        if sum(jj==(LP.hor+1))==1
            Bya1(:,jj)    = [Phat1(:,jj) CONTROLS(sel,:)]\MY(sel,jj); 
            XX1           = [P1(sel,jj) CONTROLS(sel,:)];    
            [~,~,Q]       = NeweyWest(MY(sel,jj)-XX1*Bya1(:,jj),Xfs,floor(4*((T/100)^(2/9))),0);
            varbet= (diag((T)*((Xfs'*XX1)\Q/(XX1'*Xfs))));
            SE1(jj,1) = sqrt(varbet(1,1))';
            if isempty(varargin)~=1
                Bya1_ols(:,jj) = XX1\MY(sel,jj); 
                [nwse,~,~]     = NeweyWest(MY(sel,jj)-XX1*Bya1_ols(:,jj),XX1,floor(4*((T/100)^(2/9))),0);
                SE1_ols(jj,1)  = nwse(1,1);
            end
        end
    end
    
irs      = Bya1(1,:)';
irs10    = [irs+(tinv(0.95,T-k)*SE1)  irs-(tinv(0.95,T-k)*SE1)];
irs5     = [irs+(tinv(0.975,T-k)*SE1) irs-(tinv(0.975,T-k)*SE1)];
irs1     = [irs+(tinv(0.995,T-k)*SE1) irs-(tinv(0.995,T-k)*SE1)];
IRS1     = [irs irs10 irs5 irs1];  

if isempty(varargin)~=1
    irs      = Bya1_ols(1,:)';
    irs10    = [irs+(tinv(0.95,T-k)*SE1_ols)  irs-(tinv(0.95,T-k)*SE1_ols)];
    irs5     = [irs+(tinv(0.975,T-k)*SE1_ols) irs-(tinv(0.975,T-k)*SE1_ols)];
    irs1     = [irs+(tinv(0.995,T-k)*SE1_ols) irs-(tinv(0.995,T-k)*SE1_ols)];
    IRS2     = [irs irs10 irs5 irs1];  
else
    IRS2=[];
end

