function [Fstat1] = Estimate_cum_Fstat(LP)
 
hor = max(LP.hor);
dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % Controls   
    try 
    CC  = [LP.CONTROLS LP.WCONTROLS];  % Lagged controls
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    catch
    CC  = [LP.CONTROLS ];  % Lagged controls    
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:); 
    end      
  
    % RHS Variables
    PP1  = cumsum(lagmatrix(LP.P,0:-1:-hor),2)./(LP.SCALE*ones(1,hor+1));
    P1   = PP1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    % Instrumental Variable 
     ZZ  = LP.INS;    
     Z   = ZZ((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
     
    % Controls 
    sel = (isnan(sum([P1 CONTROLS],2))==0)&(dates<=LP.se);
      
   % First Stage
    Xfs   = [Z(sel,:) CONTROLS(sel,:)];
    betfs1 = Xfs\P1(sel,:); 
    Phat1  = Xfs*betfs1;
    [T,~]    = size(Xfs);
     
    Fstat1 = zeros(hor+1,1);
    for jj = 1:hor+1 
    nwse_fs    = NeweyWest(P1(sel,jj)-Phat1(:,jj),Xfs,floor(4*((T/100)^(2/9))),0);
    Fstat1(jj,1) = betfs1(1,jj).^2./(((nwse_fs(1,1))).^2);
    end

   
    
   
    

