function [IRS, IRS_ols,IRS_olsb] = Estimate_cum_2SLSvsOLS(LP)
hor = max(LP.hor);
dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % Controls   
    CC  = [LP.CONTROLS];  % Lagged controls
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    CCb  = [LP.CONTROLSb];  % Lagged controls
    CONTROLSb = CCb((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);

    % LHS Variable
    if LP.stock==1
    MYY  = (lagmatrix(LP.Y,0:-1:-hor)-lagmatrix(LP.Y,1)*ones(1,hor+1))./(LP.SCALE*ones(1,hor+1));
    elseif LP.stock==0
    MYY  = (cumsum(lagmatrix(LP.Y,0:-1:-hor),2)-lagmatrix(LP.Y,1)*ones(1,hor+1))./(LP.SCALE*ones(1,hor+1));    
    end
    MY  = MYY((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
  
    % RHS Variables
    PP1  = cumsum(lagmatrix(LP.P,0:-1:-hor),2)./(LP.SCALE*ones(1,hor+1));
    P1   = PP1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    
    % Instrumental Variable 
    ZZ  = LP.INS;    
    Z   = ZZ((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
      
    sel = (isnan(sum([MY P1 CONTROLS],2))==0)&(dates<=LP.se);
    
 
    Xfs         = [Z(sel,:) CONTROLS(sel,:)];
    [~,k]    = size(Xfs);
    [~,kb]   = size([Z(sel,:) CONTROLSb(sel,:)]);
    betfs1      = Xfs\P1(sel,:); 
    Phat1       = Xfs*betfs1;
    Bya1        = zeros(k,hor+1);
    Bya1_ols    = zeros(k,hor+1);
    Bya1_olsb   = zeros(kb,hor+1);
    
    for jj = 1:hor+1
    	if sum(jj==(LP.hor+1))==1
        Bya1(:,jj)         = [Phat1(:,jj) CONTROLS(sel,:)]\MY(sel,jj); 
        Bya1_ols(:,jj)     = [P1(sel,jj) CONTROLS(sel,:)]\MY(sel,jj);
        Bya1_olsb(:,jj)    = [P1(sel,jj) CONTROLSb(sel,:)]\MY(sel,jj);       
        end
    end
        
IRS      = Bya1(1,:)';
IRS_ols  = Bya1_ols(1,:)';
IRS_olsb = Bya1_olsb(1,:)';



