clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];

SPEC.P1        = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'TB3'})));
SPEC.INS1      = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'RR'})));

NARR_EN = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NARR_EN'})))./PLEVEL;
NARR_EN(isnan(NARR_EN))=0;
vars    = [NARR./SPEC.SCALE NARR_EN./SPEC.SCALE];
varscum = nancumsum(vars)*100;

for jj = 1:2
    LP = SPEC;       
    LP.vars     = varscum(:,jj);
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix(vars(:,jj),1:LP.lags)];
    RES.IRSm{jj}  = Estimate_irs_mon_shock(LP);
end
shocksize = -10.1;
IRS1 = RES.IRSm{1}*shocksize;
IRS2 = RES.IRSm{2}*shocksize;

 FIG.stplot   = [0 24];
 FIG.figlabel = 'Expansionary Monetary Policy Shock'; 
 FIG.units    = 2; 
 FIG.fill     = 1; 
 FIG.name     = strcat('FigureXI_pred');
 FIG.shift    = [0 0];
 FIG.legend   = {'Non-cyclical events','Cyclical events'};
 
 tt  = 1:FIG.stplot(2);
 sel = tt>=FIG.stplot(1);

 figure
    box off
        hold on
        if FIG.fill ==1 
        X =[tt(sel)+FIG.shift(2),fliplr(tt(sel)+FIG.shift(2))];                
        Y =[IRS2(sel,4)',fliplr(IRS2(sel,5)')];
        hh=fill(X,Y,[0 0 0.5]); 
        set(hh,'facealpha',.2,'edgecolor','white')
        else
        plot(FIG.shift(1)+tt(sel),IRS2(sel,4),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-.' ); 
        plot(FIG.shift(1)+tt(sel),IRS2(sel,5),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-.' );    
        end   
        plot(FIG.shift(1)+tt(sel),IRS1(sel,4),'LineWidth',1,'Color',[0 0 0.5]); 
        plot(FIG.shift(1)+tt(sel),IRS1(sel,5),'LineWidth',1,'Color',[0 0 0.5]);         
     p1=plot(FIG.shift(1)+tt(sel),IRS1(sel,1),'LineWidth',2,'Color',[0 0 0.5]);
     p2=plot(FIG.shift(2)+tt(sel),IRS2(sel,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','-.' );
        axis([min(tt)-1 max(tt)+1+FIG.shift(2) -inf inf])  
        hline(0,'k-')
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        yl=ylabel('basis points');
        set(gca,'XTick',[0:6:48])
        l=legend([p1 p2],FIG.legend{1},FIG.legend{2});
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthWest');
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12);        
        set(gca,'LooseInset',get(gca,'TightInset'))       
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');
 
