clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1       = NCOMM;
SPEC.INS1     = NARR./SPEC.SCALE;

RES.units         =   [2       2  ] ;     
RES.LHSvariables  = {'FF','RRcum'};
                             
for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;       
    LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));    
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))),1:LP.lags)];      
    RES.IRSa{jj}  = Estimate_irs_ap_shock(LP);
end

FIG.stplot = [0 24];
for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.fill =1; 
 FIG.name     = strcat('FigureXI_',RES.LHSvariables{jj});
 FIG.shift    = [0 0];
 plot_irs(RES.IRSa{jj},FIG)
 end
