clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1        = NCOMM;
SPEC.INS1      = NARR./SPEC.SCALE;
SPEC.P2        = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'TB3'})));
SPEC.INS2      = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'RR'})));


RES.units         =   [1       1        2      2       2       2 ] ;     
RES.LHSvariables  = {'ORIG','MDEBT','CONV','HSTARTS','GS10','HOR'};
            %      [   1       2       3      4      5     6 ];

for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;

    if (jj == 1)||(jj==2)
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL);
    elseif jj == 4
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))));    
    else
    LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));
    end    
    if jj==6
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix([DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))],[1:LP.lags])];
    end
    
    [RES.IRSa{jj},RES.IRScf{jj}]  = Estimate_irs_apcf_shock(LP);
    
end


FIG.stplot = [0 24];
FIG.fill =1;
FIG.legendpos   = [0 0 0 0 0 2];
for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.name     = strcat('FigureXIII_',RES.LHSvariables{jj});
 FIG.shift    = [0 0];
 FIG.legend   = {'Benchmark','Constant Short Term Interest Rates'};
 plot_irs_apcf(RES.IRSa{jj},RES.IRScf{jj},FIG,FIG.legendpos(jj))
 end 
