clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1       = NCOMM;
SPEC.INS1     = NARR./SPEC.SCALE;

RES.units         =   [1       1        2      1       1       2 ] ;     
RES.LHSvariables  = {'HSTARTS','HPRICE','HOR','PCE','PINC','UNRATE'};
                %  [   1       2       3      4      5     6 ];


                             
for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;       
    if jj==1
        LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))));
    elseif (jj==2)||(jj==4)||(jj==5)
        LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL); 
    else
        LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));
    end    
    if jj==3
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))),1:LP.lags)];
    elseif jj==4
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix([gr(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL)],1:LP.lags)];
    end        
    RES.IRSa{jj}  = Estimate_irs_ap_shock(LP);
end

FIG.stplot = [0 24];
for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.fill =1; 
 FIG.name     = strcat('FigureX_',RES.LHSvariables{jj});
 FIG.shift    = [0 0];
 plot_irs(RES.IRSa{jj},FIG)
 end
