clear all; close all;
addpath('auxiliary_files')

DATA  = xlsread('data/MEGAP_data.xlsx','Figure I');
dates     = DATA(:,1);
RMA       = DATA(:,2);
NGDP      = DATA(:,3);
HWEALTH   = DATA(:,4);
ORIGSA    = DATA(:,5);

% Figure I upper left panel
%%%%%%%%%%%%%%%%%%%%%%%%%%%
var    = [RMA./NGDP RMA./HWEALTH]*100;
mindate = 1895;

var1   = var(isnan(var(:,1))==0,1);
dates1  = dates(isnan(var(:,1))==0,1);
var2   = var(isnan(var(:,2))==0,2);
dates2  = dates(isnan(var(:,2))==0,1);
var    = [var1;var2];

figure;
    plot_NBER_bars
    hold on 
    box off
    p1=plot(dates1,var1(:,1),'-','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',2,'MarkerFaceColor',[0 0 0.5]);
    p2=plot(dates2,var2(:,1),'-.','LineWidth',2,'Color', [0.9 0 0],'MarkerSize',2,'MarkerFaceColor',[0.9 0 0]);
    l = legend([p1 p2],'As Ratio of GDP','As Ratio of Residential Wealth');
    set(l,'Location','NorthWest','Fontsize',10,'EdgeColor','white','FontName', 'AvantGarde','Box','off')
    axis([mindate-0.25 max(dates)+0.25  ax1(1)-0.1 ax1(2)+0.1])
    set(gca,'XTick',1890:10:2016)
    hline(0,'k')
    ti = title('Residential Mortgage Debt');
    yl= ylabel('Percent');
    set(yl, 'FontName', 'AvantGarde','FontSize',10);
    set(ti, 'FontName', 'AvantGarde','FontSize',12); 
    hold off
    set(gca,'LooseInset',get(gca,'TightInset'))
    saveas(gcf,'figures/FigureI_MDEBT','epsc');

% Figure I upper right panel
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
var    = [ORIGSA(dates>1946.99)./NGDP(dates>1946.99) ORIGSA(dates>1946.99)./lagmatrix(RMA(dates>1946.99),1)]*100;
mindate = 1954;
tit    = 'Residential Mortgage Originations';

dates = dates(dates>1946.99);
var1   = var(isnan(var(:,1))==0,1);
dates1  = dates(isnan(var(:,1))==0,1);
var2   = var(isnan(var(:,2))==0,2);
dates2  = dates(isnan(var(:,2))==0,1);
var    = [var1;var2];

figure;
    plot_NBER_bars
    hold on
    box off
    p1=plot(dates1,var1(:,1),'-','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',2,'MarkerFaceColor',[0 0 0.5]);
    hold on 
    p2=plot(dates2,var2(:,1),'-.','LineWidth',2,'Color', [0.9 0 0],'MarkerSize',2,'MarkerFaceColor',[0.9 0 0]);
    l = legend([p1 p2],'As Ratio of GDP','As Ratio of Residential Mortgage Debt');
    set(l,'Location','NorthWest','Fontsize',10,'EdgeColor','white','FontName', 'AvantGarde','Box','off')
    axis([mindate-0.25 max(dates)+0.25  ax1(1)-0.1 ax1(2)+0.1])
    set(gca,'XTick',1955:5:2010)
    hline(0,'k')
    ti = title('Residential Mortgage Originations');
    yl= ylabel('Percent');
    set([yl], 'FontName', 'AvantGarde','FontSize',10);
    set([ti], 'FontName', 'AvantGarde','FontSize',12);        
    set(gca,'LooseInset',get(gca,'TightInset'))
    hold off
    saveas(gcf,'figures/FigureI_MORIG','epsc');

