clear all; close all;
addpath('auxiliary_files')

HOLD_data = xlsread('data/MEGAP_data.xlsx','Figure I Agency Holdings');
dates               = HOLD_data(:,1);
TOTAL_HOLD          = HOLD_data(:,2);
TOTAL_HOLDexclFED	= TOTAL_HOLD-HOLD_data(:,[8]);
TOTAL_HOLD_GSEs     = sum(HOLD_data(:,[3:5]),2);
RMA                 = HOLD_data(:,10);

PURCH_data = xlsread('data/MEGAP_data.xlsx','Figure I Agency Purchases');
DATES               = PURCH_data(:,1);
TOTAL_NP            = PURCH_data(:,2);
TOTAL_NP_exclFED    = PURCH_data(:,2)-PURCH_data(:,7);
TOTAL_PIQ           = PURCH_data(:,10);
ORIG                = PURCH_data(:,15);


% Figure I lower left panel
%%%%%%%%%%%%%%%%%%%%%%%%%%%
var    = [TOTAL_HOLD./RMA TOTAL_HOLDexclFED./RMA TOTAL_HOLD_GSEs./RMA]*100;
mindate = 1925;
var1   = var(isnan(var(:,1))==0,:);
dates  = dates(isnan(var(:,1))==0,1);
var    = var1;

figure;
    plot_NBER_bars
    box off
    hold on 
    p1=plot(dates,var(:,1),'-','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',2,'MarkerFaceColor',[0 0 0.5]);
    p2=plot(dates,var(:,2),'--','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',2,'MarkerFaceColor',[0 0 0.5]); 
    p3=plot(dates,var(:,3),'-.','LineWidth',2,'Color', [0.9 0 0],'MarkerSize',2,'MarkerFaceColor',[0.9 0 0]);
    l = legend([p1 p2 p3],'Total','Total excl. Federal Reserve','FNMA,FHLMC & GNMA');
    set(l,'Location','NorthWest','Fontsize',10,'EdgeColor','white','FontName', 'AvantGarde','Box','off')
    axis([mindate-0.25 max(dates)+0.25  ax1(1)-0.1 ax1(2)+0.1])
    set(gca,'XTick',1920:10:2015)
    hline(0,'k')
    ti = title('Agency Mortgage Holdings');
    yl= ylabel('Percent of Total Mortgage Debt');
    set(yl, 'FontName', 'AvantGarde','FontSize',10);
    set(ti, 'FontName', 'AvantGarde','FontSize',12); 
    hold off
    set(gca,'LooseInset',get(gca,'TightInset'))
    saveas(gcf,'figures/FigureI_HSHARE','epsc');

% Figure I lower right panel
%%%%%%%%%%%%%%%%%%%%%%%%%%%%


var = 100*[TOTAL_NP./ORIG  TOTAL_NP_exclFED./ORIG TOTAL_PIQ./ORIG];

figure
    plot_NBER_bars
    box off
    hold on 
    p1=plot(DATES,var(:,1),'LineWidth',2,'Color', [0 0 0.5]);
    p2=plot(DATES,var(:,2),'--','LineWidth',2,'Color', [0 0 0.5]);
    p3=plot(DATES,var(:,3),'-.','LineWidth',2,'Color', [0.9 0 0]);
    hline(0,'k')
    ti=title('Agency Purchases and Pool Issuance');
    yl=ylabel('Percent of Total Originations');
    l = legend([p1 p2 p3],'Total Net Portfolio Purchases','Total Net Portfolio Purchases excl. Federal Reserve','Agency Pool Issues');
    set(l, 'FontName', 'AvantGarde','Fontsize',10,'Location','NorthWest','Box','off');
    set(yl, 'FontName', 'AvantGarde','FontSize',10);
    set(ti, 'FontName', 'AvantGarde','FontSize',12); 
    hold off
    set(gca,'LooseInset',get(gca,'TightInset'))
    axis([1953 2015 -5 140])
    set(gca,'XTick',1950:5:2010)
    saveas(gcf,'figures/FigureI_PSHARE','epsc');









