clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1        = NCOMM;
SPEC.INS1      = NARR./SPEC.SCALE;

RES.units         =   [1       1        2      2       2       2 ] ;     
RES.LHSvariables  = {'ORIG','MDEBT','CONV','FHA','GS10','TB3'};
            %  [   1       2       3      4      5     6 ];

for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;
    if (jj == 1)||(jj==2)
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL);
    else
    LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));
    end
    
    if jj==4
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix([DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))],[1:LP.lags])];
    end
    
LP1 = LP;
IRS1{jj}  = Estimate_irs_ap_shock(LP1,'No Bands');

LP2 = LP;
LP2.INS1((LP.dates>2004+5/12)&(LP.dates<2005))=0;
DUM = zeros(size(LP2.INS1));
DUM((LP.dates>2004+5/12)&(LP.dates<2005)) = LP.INS1((LP.dates>2004+5/12)&(LP.dates<2005));
LP2.CONTROLS = [LP.CONTROLS DUM];
IRS2{jj}  = Estimate_irs_ap_shock(LP2,'No Bands');

LP3 = LP;
LP3.INS1((LP.dates>1981)&(LP.dates<1983))=0;
DUM = zeros(size(LP3.INS1));
DUM((LP.dates>1981)&(LP.dates<1983)) = LP.INS1((LP.dates>1981)&(LP.dates<1983));
LP3.CONTROLS = [LP.CONTROLS DUM];
IRS3{jj}  = Estimate_irs_ap_shock(LP3,'No Bands');

LP4 = LP;
LP4.INS1((LP.dates>1977)&(LP.dates<1978))=0;
DUM = zeros(size(LP4.INS1));
DUM((LP.dates>1977)&(LP.dates<1978)) = LP.INS1((LP.dates>1977)&(LP.dates<1978));
LP4.CONTROLS = [LP.CONTROLS DUM];
IRS4{jj}  = Estimate_irs_ap_shock(LP4,'No Bands');    
end


FIG.stplot = [0 24];
tt  = 1:FIG.stplot(2);
sel = tt>=FIG.stplot(1);
FIG.legendpos   = [0   0 0 0   0  3 0];
for jj = 1:size(RES.LHSvariables,2) 
FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
FIG.units    = RES.units(jj); 
FIG.name     = strcat('FigureIX_',RES.LHSvariables{jj});
FIG.legend   = {'Benchmark','Omitting Sept 2004','Omitting Dec 1982','Omitting Oct 1977'};
figure
    box off
        hold on
        p1=plot(tt(sel),IRS1{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5]);       
        p2=plot(tt(sel),IRS2{jj}(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','--');
        p3=plot(tt(sel),IRS3{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','-.');
        p4=plot(tt(sel),IRS4{jj}(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle',':'); 
        hline(0,'k-')
        l=legend([p1 p2 p3 p4],FIG.legend{1},FIG.legend{2},FIG.legend{3},FIG.legend{4});
        if jj==6
        set(l, 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthEast');
        else
        set(l, 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthWest');
        end
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        if FIG.units==1
        yl=ylabel('percent');
        elseif FIG.units==2
        yl=ylabel('basis points');
        end
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');
end



