clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:60;
SPEC.SCALE    = X_PINCT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = NARR./SPEC.SCALE;

% Left Panel
%%%%%%%%%%%%%%
% Commitments   
    LP          = SPEC;
    LP.P        = NCOMM;
    Fstat1      = Estimate_cum_Fstat(LP);
% Net Purchases      
    LP          = SPEC;
    LP.P        = NPURC;
    Fstat2      = Estimate_cum_Fstat(LP);

tt  = 1:max(SPEC.hor)+1;
figure
    box on
        hold on
        l1=plot(tt,Fstat1(:,1),'LineWidth',2,'Color', [0 0 0.5] );
        l2=plot(tt,Fstat2(:,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','--' ); 
        yl=ylabel('Statistic');
        xl=xlabel('horizon (months)');
        ti=title('First Stage Robust F-statistic');
        l=legend([l1 l2],'Agency Commitments','Agency Purchases');
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set(l,'Location','SouthEast','Fontsize',12,'EdgeColor','white','FontName', 'AvantGarde','Box','off')
        set([ti], 'FontName', 'AvantGarde','FontSize',12);
        axis([min(tt)-1 max(tt)+1 0 max([Fstat1(:,1);Fstat2(:,1)])+2])
        box off
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/','FigureIV_Fstats');
        saveas(gcf,str,'epsc');

% Right panel
%%%%%%%%%%%%%
LP            = SPEC;
LP.P          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'COM'})))./PLEVEL;
LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NP'})))./PLEVEL; 
LP.stock      = 0;
IRS           = Estimate_cum_multipliers(LP);

FIG.stplot   = [4 48];
FIG.name     = strcat('FigureIV_','NP');

figure
    tt  = 1:FIG.stplot(2);
    sel = tt>=FIG.stplot(1);
    box off
        hold on
        plot(tt(sel),IRS(sel,1),'LineWidth',2,'Color',[0 0 0.5] );
        plot(tt(sel),IRS(sel,4),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-' ); 
        plot(tt(sel),IRS(sel,5),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','-' ); 
        hline(0,'k-')
        ti=title(DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{'NP'}))});
        xl=xlabel('horizon (months)');
        yl=ylabel('dollars');
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');

  

