clear all; close all;
addpath('auxiliary_files')

DATA  = xlsread('data/MEGAP_data.xlsx','Figure III');
DATES = DATA(:,1);
ORIG  = sum(lagmatrix(DATA(:,4),[1:12]),2);
NARRX = DATA(:,2)./ORIG;
NARRE = DATA(:,3)./ORIG;

SAM.sb = 1967;
SAM.se = DATES(end)+3/12;

%Credit cycle peaks
pks  = [1955.50 1959.00 1965.75 1968.75 1972.75 1978.00 1980.75 1990.00 1998.25 2007.25];
thrs = [1957.75  1960.25 1966.50 1970.00 1974.50 1980.00 1981.75 1992.75 1998.75 2014.75];

figure 
    box off
    hold on
    vars = [NARRX]*100;
    ax1=[min(vars(:))-0.1*abs(min(vars(:))),max(vars(:))+0.1*abs(max(vars(:)))];
    for j=1:length(pks)   
     Yy=[ax1(1) ax1(1) ax1(2) ax1(2) ];
     Xx=[pks(j),thrs(j),thrs(j),pks(j)];
     h=fill(Xx,Yy, [0.9 0.9 0.9]);
     set(h,'EdgeColor','None');
    end
    b1=bar(DATES,NARRX*100,'FaceColor',[0 0 0.5]);
    plot(DATES,0*ones(length(DATES),1),'k-')
    yl = ylabel('Percent of Originations');
    xl=xlabel(' ');
    ti = title('Not Cyclically Motivated');
    axis([SAM.sb SAM.se ax1(1) ax1(2)])
    set([yl,xl], 'FontName', 'AvantGarde','FontSize',10);
    set([ti], 'FontName', 'AvantGarde','FontSize',12);        
    set(gca,'LooseInset',get(gca,'TightInset'))
    saveas(gcf,'figures/FigureIII_noncycl','epsc')


figure 
    box off 
    hold on
    vars = [NARRE]*100;
    ax1=[min(vars(:))-0.1*abs(min(vars(:))),max(vars(:))+0.1*abs(max(vars(:)))];
    for j=1:length(pks)   
     Yy=[ax1(1) ax1(1) ax1(2) ax1(2) ];
     Xx=[pks(j),thrs(j),thrs(j),pks(j)];
     h=fill(Xx,Yy, [0.9 0.9 0.9]);
     set(h,'EdgeColor','None');
    end
    b2=bar(DATES,NARRE*100,'FaceColor',[0 0 0.5]);
    plot(DATES,0*ones(length(DATES),1),'k-')
    yl = ylabel('Percent of Originations');
    xl=xlabel(' ');
    ti = title('Cyclically Motivated');
    axis([SAM.sb SAM.se ax1(1) ax1(2)])
    set([yl,xl], 'FontName', 'AvantGarde','FontSize',10);
    set([ti], 'FontName', 'AvantGarde','FontSize',12);        
    set(gca,'LooseInset',get(gca,'TightInset'))
    saveas(gcf,'figures/FigureIII_cycl','epsc')
