clear all; close all;
addpath('auxiliary_files')

sam.be = 1947;
sam.se = 2015;

DATA      = xlsread('data/MEGAP_data.xlsx','Figure II');
DATA      = DATA((DATA(:,1)>=sam.be)&(DATA(:,1)<=sam.se),:);
DATES          = DATA(:,1);
GOV            = DATA(:,2);
PRIV           = DATA(:,3);
PCEP           = DATA(:,4);
MDO            = GOV+PRIV;
RGOV           = log(GOV./PCEP);
RPRIV          = log(PRIV./PCEP);

% Figure II left panel
%%%%%%%%%%%%%%%%%%%%%%

%NBER business cycle peaks
pks   = [1890.50 1893.00 1895.75 1899.25 1902.75 1907.25 1910.00 1913.00 1918.50 1920.00 1923.25 1926.50 1929.50 1937.25...
         1945.00 1948.75 1953.50 1957.50 1960.25 1969.75 1973.75 1980.00 1981.50 ...
    1990.50 2001.00 2007.75];

jj = 1;
jjj = 1;
for j = 1:length(pks)
    if (pks(j)>=1954)&&(pks(j)<=2008)
       ind(:,jj) = (DATES>=pks(j)-0.01) & (DATES<=pks(j)+0.01);       
       pp = find(ind(:,jj),1);
       RRGOV(:,jj) = RGOV(pp-8:pp+12)-RGOV(pp); 
       RRPRIV(:,jj) = RPRIV(pp-8:pp+12)-RPRIV(pp);
       jj = jj+1;
    end  
    
    if (pks(j)>=1954)&&(pks(j)<=2006)
       ind(:,jjj) = (DATES>=pks(j)-0.01) & (DATES<=pks(j)+0.01);       
       pp = find(ind(:,jjj),1);
       RRGOVex(:,jjj) = RGOV(pp-8:pp+12)-RGOV(pp); 
       RRPRIVex(:,jjj) = RPRIV(pp-8:pp+12)-RPRIV(pp);
       jjj = jjj+1;
    end   
    
end
    

t = -8:12;
figure
    box off
    hold on
    p1=plot(t,100.*mean(RRGOV,2),'-','LineWidth',2,'Color', [0 0 0.5]);
    p2=plot(t,100.*mean(RRGOVex,2),'--','LineWidth',2,'Color', [0 0 0.5]);
    p3=plot(t,100.*mean(RRPRIV,2),'-','LineWidth',2,'Color', [0.9 0 0]);
    p4=plot(t,100.*mean(RRPRIVex,2),'--','LineWidth',2,'Color', [0.9 0 0]);
    hline(0,'k')
    ti=title('Recessions');
    xl=xlabel('Quarters from Peak');
    yl = ylabel('Log Difference with Peak');
    l = legend([p1 p2 p3 p4],'Agency Held','Agency Held excl. Great Recession','Privately Held','Privately Held excl. Great Recession');
    set(l, 'FontName', 'AvantGarde','Fontsize',10,'Location','NorthWest','Box','off');
    axis([min(t) max(t) -25,40])
    vline(0,'k--')
    set([yl,xl], 'FontName', 'AvantGarde','FontSize',10);
    set(ti, 'FontName', 'AvantGarde','FontSize',12);        
    set(gca,'LooseInset',get(gca,'TightInset'))
    box off
    saveas(gcf,'figures/FigureII_buscycl','epsc');



% Figure II right panel
%%%%%%%%%%%%%%%%%%%%%%%

%Credit cycle peaks
pks_ES1986   = [1955.50 1959.00 1965.75 1968.75 1972.75 1978.00 1980.75] ;
pks_OS1993   = [1966.00 1969.00 1979.75 1990.00];
pks_BH2010   = [2007.25];
pks = [pks_ES1986 1990.00 1998.25 pks_BH2010];

jj = 1;
jjj = 1;
for j = 1:length(pks)
    if (pks(j)>=1951)&&(pks(j)<=2008)
       ind(:,jj) = (DATES>=pks(j)-0.01) & (DATES<=pks(j)+0.01);       
       pp = find(ind(:,jj),1);
       RRGOV(:,jj) = RGOV(pp-8:pp+12)-RGOV(pp); 
       RRPRIV(:,jj) = RPRIV(pp-8:pp+12)-RPRIV(pp);
       jj = jj+1;
    end  
    
    if (pks(j)>=1951)&&(pks(j)<=2006)
       ind(:,jjj) = (DATES>=pks(j)-0.01) & (DATES<=pks(j)+0.01);       
       pp = find(ind(:,jjj),1);
       RRGOVex(:,jjj) = RGOV(pp-8:pp+12)-RGOV(pp); 
       RRPRIVex(:,jjj) = RPRIV(pp-8:pp+12)-RPRIV(pp);
       jjj = jjj+1;
    end   
    
end

t = -8:12;
figure
    box off
    hold on
    p1=plot(t,100.*mean(RRGOV,2),'-','LineWidth',2,'Color', [0 0 0.5]);
    p2=plot(t,100.*mean(RRGOVex,2),'--','LineWidth',2,'Color', [0 0 0.5]);
    p3=plot(t,100.*mean(RRPRIV,2),'-','LineWidth',2,'Color', [0.9 0 0]);
    p4=plot(t,100.*mean(RRPRIVex,2),'--','LineWidth',2,'Color', [0.9 0 0]);
    hline(0,'k')
    ti=title('Credit Crunches');
    xl=xlabel('Quarters from Peak');
    yl = ylabel('Log Difference with Peak');
    l = legend([p1 p2 p3 p4],'Agency Held','Agency Held excl. 2007 Financial Crisis','Privately Held','Privately Held excl. 2007 Financial Crisis');
    set(l, 'FontName', 'AvantGarde','Fontsize',10,'Location','NorthWest','Box','off');
    axis([min(t) max(t) -25,40])
    vline(0,'k--')
    set([yl,xl], 'FontName', 'AvantGarde','FontSize',10);
    set(ti, 'FontName', 'AvantGarde','FontSize',12);        
    set(gca,'LooseInset',get(gca,'TightInset'))
    box off
    saveas(gcf,'figures/FigureII_credcru','epsc');

