clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = [12 18 24 36 48]-1;
SPEC.SCALE    = X_PINCT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = NARR./SPEC.SCALE;
SPEC.P        = NCOMM;


RES.stock         = [  1     1      1      0   ]; % 1: stock variable   0: flow variable
RES.LHSvariables  = {'MH', 'PMH','MDEBT', 'ORIG'};

% Benchmark
LP            = SPEC;
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,1,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,1,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,1,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,1,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,1,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,1,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,1,jj)  = IRS1(SPEC.hor+1,7);
end

% Full Sample
LP            = SPEC;
LP.se         = 2015;
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,2,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,2,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,2,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,2,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,2,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,2,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,2,jj)  = IRS1(SPEC.hor+1,7);
end

% Post 1982 Sample
LP            = SPEC;
LP.sb  = 1982+9/12; LP.se  = 2006.99;
LP.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS],1:SPEC.lags) SPEC.DET];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,3,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,3,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,3,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,3,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,3,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,3,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,3,jj)  = IRS1(SPEC.hor+1,7);
end

% Omitting Sept 2004
LP            = SPEC;
LP.INS((LP.dates>2004+5/12)&(LP.dates<2005))=0;
DUM = zeros(size(LP.INS));
DUM((LP.dates>2004+5/12)&(LP.dates<2005)) = SPEC.INS((LP.dates>2004+5/12)&(LP.dates<2005));
LP.CONTROLS = [LP.CONTROLS lagmatrix(DUM,[0:LP.lags])];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,4,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,4,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,4,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,4,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,4,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,4,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,4,jj)  = IRS1(SPEC.hor+1,7);
end

% Omitting Dec 1982
LP            = SPEC;
LP.INS((LP.dates>1981)&(LP.dates<1983))=0;
DUM = zeros(size(LP.INS));
DUM((LP.dates>1981)&(LP.dates<1983)) = SPEC.INS((LP.dates>1981)&(LP.dates<1983));
LP.CONTROLS = [LP.CONTROLS lagmatrix(DUM,[0:LP.lags])];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,5,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,5,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,5,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,5,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,5,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,5,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,5,jj)  = IRS1(SPEC.hor+1,7);
end


% Omitting  Oct 1977
LP            = SPEC;
LP.INS((LP.dates>1977)&(LP.dates<1978))=0;
DUM = zeros(size(LP.INS));
DUM((LP.dates>1977)&(LP.dates<1978)) = SPEC.INS((LP.dates>1977)&(LP.dates<1978));
LP.CONTROLS = [LP.CONTROLS lagmatrix(DUM,[0:LP.lags])];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,6,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,6,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,6,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,6,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,6,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,6,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,6,jj)  = IRS1(SPEC.hor+1,7);
end

% Controls Including Pools Issues
LP            = SPEC;
POOLS = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PI'})))./PLEVEL;
LP.CONTROLS = [LP.CONTROLS lagmatrix(POOLS./SPEC.SCALE,[1:LP.lags])];

for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,7,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,7,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,7,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,7,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,7,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,7,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,7,jj)  = IRS1(SPEC.hor+1,7);
end


% Controls Including GSE Stock Index
LP            = SPEC;
LP.CONTROLS = [LP.CONTROLS lagmatrix(log(GSE_index./SP500),[1:LP.lags])];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,8,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,8,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,8,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,8,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,8,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,8,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,8,jj)  = IRS1(SPEC.hor+1,7);
end

ti = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{1:4}}))};
doTable(IRS,ti,LP.hor)


