clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Benchmark Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = [12 18 24 36 48]-1;
SPEC.SCALE    = X_PINCT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = NARR./SPEC.SCALE;
SPEC.P        = NCOMM;

RES.stock         = [  1     1      1      0   ]; % 1: stock variable   0: flow variable
RES.LHSvariables  = {'MH', 'PMH','MDEBT', 'ORIG'};

% Columns 1/2
%%%%%%%%%%%%%
LP            = SPEC;
LP.CONTROLS   = [lagmatrix([MCONTROLS],1:SPEC.lags) SPEC.DET];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP,'Also report OLS');
    IRS.b(:,2,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,2,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,2,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,2,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,2,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,2,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,2,jj)  = IRS1(SPEC.hor+1,7);
    IRS.b(:,1,jj)   = IRS2(SPEC.hor+1,1);
IRS.CI_H90(:,1,jj)  = IRS2(SPEC.hor+1,2); IRS.CI_L90(:,1,jj)  = IRS2(SPEC.hor+1,3);
IRS.CI_H95(:,1,jj)  = IRS2(SPEC.hor+1,4); IRS.CI_L95(:,1,jj)  = IRS2(SPEC.hor+1,5);
IRS.CI_H99(:,1,jj)  = IRS2(SPEC.hor+1,6); IRS.CI_L99(:,1,jj)  = IRS2(SPEC.hor+1,7);
end

% Columns 3/4
%%%%%%%%%%%%%
LP            = SPEC;
LP.CONTROLS   = [lagmatrix([MCONTROLS RCONTROLS],1:SPEC.lags) SPEC.DET];
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP,'Also report OLS');
    IRS.b(:,4,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,4,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,4,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,4,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,4,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,4,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,4,jj)  = IRS1(SPEC.hor+1,7);
    IRS.b(:,3,jj)   = IRS2(SPEC.hor+1,1);
IRS.CI_H90(:,3,jj)  = IRS2(SPEC.hor+1,2); IRS.CI_L90(:,3,jj)  = IRS2(SPEC.hor+1,3);
IRS.CI_H95(:,3,jj)  = IRS2(SPEC.hor+1,4); IRS.CI_L95(:,3,jj)  = IRS2(SPEC.hor+1,5);
IRS.CI_H99(:,3,jj)  = IRS2(SPEC.hor+1,6); IRS.CI_L99(:,3,jj)  = IRS2(SPEC.hor+1,7);
end

% Columns 5/6
%%%%%%%%%%%%%
LP            = SPEC;
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP,'Also report OLS');
    IRS.b(:,6,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,6,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,6,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,6,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,6,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,6,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,6,jj)  = IRS1(SPEC.hor+1,7);
    IRS.b(:,5,jj)   = IRS2(SPEC.hor+1,1);
IRS.CI_H90(:,5,jj)  = IRS2(SPEC.hor+1,2); IRS.CI_L90(:,6,jj)  = IRS2(SPEC.hor+1,3);
IRS.CI_H95(:,5,jj)  = IRS2(SPEC.hor+1,4); IRS.CI_L95(:,6,jj)  = IRS2(SPEC.hor+1,5);
IRS.CI_H99(:,5,jj)  = IRS2(SPEC.hor+1,6); IRS.CI_L99(:,6,jj)  = IRS2(SPEC.hor+1,7);
end

% Column 7
%%%%%%%%%%
LP            = SPEC;
LP.P          = NPURC;
for jj = 1:length(RES.LHSvariables)           
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,7,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,7,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,7,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,7,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,7,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,7,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,7,jj)  = IRS1(SPEC.hor+1,7);
end

% Column 8
%%%%%%%%%%
LP            = SPEC;
NARR_EN       = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NARR_EN'})))./PLEVEL;
NARR_EN(isnan(NARR_EN))=0;
LP.INS        = (NARR+NARR_EN)./SPEC.SCALE;
for jj = 1:length(RES.LHSvariables)        
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1,IRS2]   = Estimate_cum_multipliers(LP);
    IRS.b(:,8,jj)   = IRS1(SPEC.hor+1,1);
IRS.CI_H90(:,8,jj)  = IRS1(SPEC.hor+1,2); IRS.CI_L90(:,8,jj)  = IRS1(SPEC.hor+1,3);
IRS.CI_H95(:,8,jj)  = IRS1(SPEC.hor+1,4); IRS.CI_L95(:,8,jj)  = IRS1(SPEC.hor+1,5);
IRS.CI_H99(:,8,jj)  = IRS1(SPEC.hor+1,6); IRS.CI_L99(:,8,jj)  = IRS1(SPEC.hor+1,7);
end

ti = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{1:4}}))};
doTable(IRS,ti,LP.hor)


