clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Additional Lagged Controls:
ECONTROLS = [log(GSE_index./index_m) log(index_m./index_f)];
% Contemporaneous Controls:
WCONTROLS = [log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'MDEBT'})))./PLEVEL)...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'CONV'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SBAA','TB3','GS10'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SCONV'})))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HPRICE'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HSTARTS'}))))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI'}))))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'UNRATE'})))... 
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'}))))...
             log(index_re./index_m)-lagmatrix(log(index_re./index_m),1)...
             log(index_m./index_f)-lagmatrix(log(index_m./index_f),1)...
             log(index_fi./index_m)-lagmatrix(log(index_fi./index_m),1)];
WCONTROLS(:,[2 8 10 12]) = WCONTROLS(:,[2 8 10 12])-lagmatrix(WCONTROLS(:,[2 8 10 12]),1);

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS ECONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1        = NCOMM;
SPEC.INS1      = log(GSE_index./index_m)-lagmatrix(log(GSE_index./index_m),1);
SPEC.WCONTROLS = WCONTROLS;

RES.units         =   [1       1        2      2       2       2  1       1        2      1       1       2   1  1 ] ;     
RES.LHSvariables  = {'ORIG','MDEBT','CONV','FHA','GS10','TB3','HSTARTS','HPRICE','HOR','PCE','PINC','UNRATE','ORIG_RF','ORIG_PUR'};
               %  [   1       2       3      4      5     6         7        8        9     10   11     12       13        14];
warning off
for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;

    if (jj == 1)||(jj==2)||(jj==8)||(jj==10)||(jj==11)||(jj==13)||(jj==14)
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL);
    elseif jj==7
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))));    
    else
    LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));
    end
    
    if (jj==4)||(jj==9)
    LP.WCONTROLS = [SPEC.WCONTROLS DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))];    
    LP.CONTROLS  = [SPEC.CONTROLS lagmatrix([DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))],[1:LP.lags])];
    elseif (jj == 10)
    LP.WCONTROLS = [SPEC.WCONTROLS LP.vars-lagmatrix(LP.vars,1)];    
    LP.CONTROLS  = [SPEC.CONTROLS lagmatrix([gr(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL)],1:LP.lags)];
    elseif (jj == 13)||(jj == 14)
    LP.WCONTROLS = [SPEC.WCONTROLS LP.vars];    
    LP.CONTROLS  = [SPEC.CONTROLS lagmatrix(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL,1:LP.lags)]; 
    end
    
    RES.IRSa{jj}  = Estimate_irs_ap_shock(LP);
    
end


FIG.stplot = [0 24];
for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.fill =1; 
 FIG.name     = strcat('FigureXXVII_',RES.LHSvariables{jj});
 FIG.shift    = [0 0];
 plot_irs(RES.IRSa{jj},FIG)
end

 