clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES
RR = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'RR'})));

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1        = NCOMM;
SPEC.INS1      = NARR./SPEC.SCALE;

RES.units         =   [1       1        2      2       2       2 ] ;     
RES.LHSvariables  = {'ORIG','MDEBT','CONV','FHA','GS10','TB3'};
            %  [   1       2       3      4      5     6 ];

for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;

    if (jj == 1)||(jj==2)
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL);
    else
    LP.vars     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})));
    end
    
    if jj==4
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix([DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))],[1:LP.lags])];
    end
    
    RES.IRSa1{jj}  = Estimate_irs_ap_shock(LP);
    LP.CONTROLS = [RR lagmatrix([RR MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
    RES.IRSa2{jj}  = Estimate_irs_ap_shock(LP);
end

FIG.stplot = [0 24];
tt  = 1:FIG.stplot(2);
sel = tt>=FIG.stplot(1);
FIG.fill =1; 
FIG.legend   = {'Benchmark','Including Romer and Romer (2004) shocks'};

for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.name     = strcat('FigureXXV_',RES.LHSvariables{jj});

 IRS1 =RES.IRSa1{jj};
 IRS2 =RES.IRSa2{jj};

 figure
    box off
        hold on
        if FIG.fill ==1 
        X =[tt(sel),fliplr(tt(sel))];                
        Y =[IRS2(sel,4)',fliplr(IRS2(sel,5)')];
        hh=fill(X,Y,[0.9 0 0]); 
        set(hh,'facealpha',.2,'edgecolor','white')
        else
        plot(tt(sel),IRS2(sel,4),'LineWidth',1,'Color',[0.9 0 0],'LineStyle','-.' ); 
        plot(tt(sel),IRS2(sel,5),'LineWidth',1,'Color',[0.9 0 0],'LineStyle','-.' );    
        end
   
        plot(tt(sel),IRS1(sel,4),'LineWidth',1,'Color',[0 0 0.5] ); 
        plot(tt(sel),IRS1(sel,5),'LineWidth',1,'Color',[0 0 0.5] );         
     p1=plot(tt(sel),IRS1(sel,1),'LineWidth',2,'Color',[0 0 0.5] );
     p2=plot(tt(sel),IRS2(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','-.' );

        axis([min(tt)-1 max(tt)+1 -inf inf])
  
        hline(0,'k-')
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        if FIG.units==1
        yl=ylabel('percent');
        elseif FIG.units==2
        yl=ylabel('basis points');
        elseif FIG.units==3
        yl=ylabel('dollars');
        end
        set(gca,'XTick',[0:6:48])
        
        l=legend([p1 p2],FIG.legend{1},FIG.legend{2});
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthWest');
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12);        
        set(gca,'LooseInset',get(gca,'TightInset'))
       
       str=strcat('figures/',FIG.name);
       saveas(gcf,str,'epsc');
 end
