clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

PVAR.irhor = 3*12;
PVAR.dates = DATES;
PVAR.sb  = 1971+7/12;
PVAR.se  = 2006.99;
PVAR.p =  12;                                                     
VARS = [log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL)...
        log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'MDEBT'})))./PLEVEL)...
        DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'CONV'})))... 
        DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SBAA','TB3','GS10'})))... 
        log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HPRICE'})))./PLEVEL)... 
        log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HSTARTS'}))))... 
        log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI'}))))... 
        DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'UNRATE'})))...  
        log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'})))./PLEVEL)... 
        log(index_m./index_f)...
        log(index_re./index_m)...
        log(GSE_index./index_m)... 
        NCOMM./X_ORIGT*100 ... 
        NPURC./X_ORIGT*100 ];  
VARS(:,2) = VARS(:,2)-lagmatrix(VARS(:,2),1);                                                                                                                                                               
PVAR.vars = VARS((DATES>=PVAR.sb-PVAR.p/12)&(DATES<=PVAR.se),:);
MSHOCKS     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'RR'})));
PVAR.MSHOCKS = MSHOCKS((DATES>=PVAR.sb-PVAR.p/12)&(DATES<=PVAR.se),:);

units                  =   [1     1        2      2     2      2      1       1         1       2        1     1    1     1     2    2 ] ;     
PVAR.select_variables  = {'ORIG','MDEBT','CONV','SBAA','TB3','GS10','HPRICE','HSTARTS','PCEPI','UNRATE','PINC','index_m','index_re','GSE_index','COM','NP'};
PVAR.MAP       = containers.Map([PVAR.select_variables],[1:size(PVAR.vars,2)]); 
PVAR.FIGLABELS = [DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,PVAR.select_variables))}];


T = length(PVAR.vars);
PVAR.DET = [ones(T,1)];

nboot  = 10000;
clevel = [95 68]; 
PVAR.shocksize = 1; 
PVAR   = doSVAR(PVAR);
PVARbs = doSVARbootstrap(PVAR,nboot,clevel);


FIG.stplot = [0 24];
FIG.fill =1;
for jj = [1 2 3 5 6 8]
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{PVAR.select_variables{jj}}))}; 
 FIG.units    = units(jj); 
 FIG.name     = strcat('FigureXXIX_',PVAR.select_variables{jj});
 FIG.shift    = [0 0];
 plot_irs(6.66*[PVAR.irs(:,jj) zeros(PVAR.irhor,2) PVARbs.irsH1(:,jj) PVARbs.irsL1(:,jj)...
           zeros(PVAR.irhor,2) PVARbs.irsH2(:,jj) PVARbs.irsL2(:,jj)],FIG)
end 


 FIG.stplot = [0 36];

tt  = 1:FIG.stplot(2);
sel = tt>=FIG.stplot(1);
FIG.legendpos   = zeros(1,16);
FIG.legendpos([1 2 3 6 8])   = 3;
FIG.legendpos(5)   = 1;

 for jj = [1 2 3 5 6 8]
 IRS(:,1) = PVAR.FEVD1(:,jj)*100;
 IRS(:,2) = PVAR.FEVD2(:,jj)*100;

 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{PVAR.select_variables{jj}}))}; 
 FIG.units    = 1; 
 FIG.name     = strcat('FigureXXX_',PVAR.select_variables{jj}); 
 FIG.legend   = {'GSE excess returns shock','Monetary shock'};
 figure
    box off
        hold on
        p1=plot(tt(sel),IRS(sel,1),'LineWidth',2,'Color',[0 0 0.5]);       
        p2=plot(tt(sel),IRS(sel,2),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','--');
        l=legend([p1 p2],FIG.legend{1},FIG.legend{2});           
        hline(0,'k-')
        if FIG.legendpos(jj)==0  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthWest');
        elseif FIG.legendpos(jj)==1  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','NorthEast');
        elseif FIG.legendpos(jj)==2  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthWest');
        elseif FIG.legendpos(jj)==3  
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthEast');
        end
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');
        yl=ylabel('percent');
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set(gca,'LooseInset',get(gca,'TightInset'))
       str=strcat('figures/',FIG.name);
       saveas(gcf,str,'epsc');
 end