clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P1        = NCOMM;
SPEC.INS1      = NARR./SPEC.SCALE;

RES.units         =   [1       1        1] ;     
RES.LHSvariables  = {'ORIG', 'ORIG_RF', 'ORIG_PUR'};

for jj = 1:size(RES.LHSvariables,2)
LP = SPEC;
    LP.vars     = log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL);
    if jj>1
    LP.CONTROLS = [SPEC.CONTROLS lagmatrix(LP.vars,[1:LP.lags])];
    end       
    RES.IRSa{jj}  = Estimate_irs_ap_shock(LP);

LPmon = LP;    
LPmon.P1        = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'TB3'})));
LPmon.INS1      = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'RR'})));

    RES.IRSm{jj}  = Estimate_irs_mon_shock(LPmon);
end

FIG.stplot = [0 24];
FIG.fill =1;
FIG.legendpos   = [0 0 0];
for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = RES.units(jj); 
 FIG.name     = strcat('FigureXXII_',RES.LHSvariables{jj});
 FIG.shift    = [0 4];
 FIG.legend   = {'Agency Purchase Shock','Monetary Policy Shock'};
 plot_irs_mon(RES.IRSa{jj},RES.IRSm{jj},FIG,FIG.legendpos(jj))
 end 
