clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Specification
SPEC.dates     = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb        = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags      = 12; 
SPEC.hor       = 0:50;
SPEC.SCALE     = X_PINCT;
SPEC.DET       = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS  = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.CONTROLSb = [lagmatrix(MCONTROLS,1:SPEC.lags) SPEC.DET];
SPEC.INS       = NARR./SPEC.SCALE;

RES.stock         = [  1     1      0      1    ]; % 1: stock variable   0: flow variable
RES.LHSvariables  = {'MH', 'PMH', 'ORIG','MDEBT'};

% Using Commitments
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NCOMM;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1c{jj},IRS2c{jj},IRS3c{jj}]  = Estimate_cum_2SLSvsOLS(LP); 
    end

% Using Net Purchases
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NPURC;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    [IRS1p{jj},IRS2p{jj},IRS3p{jj}]  = Estimate_cum_2SLSvsOLS(LP); 
    end
    
    
FIG.stplot = [4 48];
FIG.legend   = {'2SLS with full controls','OLS with full controls','OLS with baseline controls '};
 for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
     if jj == 3 
     FIG.figlabel = 'Mortgage Originations: Total';   
     end
 FIG.name     = strcat('FigureXX_comm',RES.LHSvariables{jj}); 
 tt  = 1:FIG.stplot(2);
 sel = tt>=FIG.stplot(1);

 figure
    box off
        hold on
        p1=plot(tt(sel),IRS1c{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5]);       
        p2=plot(tt(sel),IRS2c{jj}(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','--');
        p3=plot(tt(sel),IRS3c{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','-.');
        hline(0,'k-')
        l=legend([p1 p2 p3],FIG.legend{1},FIG.legend{2},FIG.legend{3});
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');       
        yl=ylabel('dollars');
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthEast');
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');
 end  
 
 

 
 for jj = 1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
     if jj == 3 
     FIG.figlabel = 'Mortgage Originations: Total';   
     end
 FIG.name     = strcat('FigureXX_purch',RES.LHSvariables{jj}); 
 tt  = 1:FIG.stplot(2);
 sel = tt>=FIG.stplot(1);
 
  figure
    box off
        hold on
        p1=plot(tt(sel),IRS1p{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5]);       
        p2=plot(tt(sel),IRS2p{jj}(sel,1),'LineWidth',2,'Color',[0.9 0 0],'LineStyle','--');
        p3=plot(tt(sel),IRS3p{jj}(sel,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','-.');
        hline(0,'k-')
        l=legend([p1 p2 p3],FIG.legend{1},FIG.legend{2},FIG.legend{3});
        ti=title(FIG.figlabel);
        xl=xlabel('horizon (months)');       
        yl=ylabel('dollars');
        set(gca,'XTick',[0:6:48])
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set([ti], 'FontName', 'AvantGarde','FontSize',12); 
        set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthEast');
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/',FIG.name);
        saveas(gcf,str,'epsc');
 end
 