clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Additional Lagged Controls:
ECONTROLS = [log(GSE_index./index_m) log(index_m./index_f)];
% Contemporaneous Controls:
WCONTROLS = [log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'MDEBT'})))./PLEVEL)...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'CONV'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SBAA','TB3','GS10'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SCONV'})))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HPRICE'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HSTARTS'}))))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI'}))))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'UNRATE'})))... 
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'}))))...
             log(index_re./index_m)-lagmatrix(log(index_re./index_m),1)...
             log(index_m./index_f)-lagmatrix(log(index_m./index_f),1)];
WCONTROLS(:,[2 8 10 12]) = WCONTROLS(:,[2 8 10 12])-lagmatrix(WCONTROLS(:,[2 8 10 12]),1);

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:60;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS ECONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = log(GSE_index./index_m)-lagmatrix(log(GSE_index./index_m),1);
SPEC.WCONTROLS = WCONTROLS;

% Left Panel
%%%%%%%%%%%%%%
% Commitments   
    LP          = SPEC;
    LP.P        = NCOMM;
    Fstat1      = Estimate_cum_Fstat(LP);
% Net Purchases      
    LP          = SPEC;
    LP.P        = NPURC;
    Fstat2      = Estimate_cum_Fstat(LP);

tt  = 1:max(SPEC.hor)+1;
figure
    box on
        hold on
        l1=plot(tt,Fstat1(:,1),'LineWidth',2,'Color', [0 0 0.5] );
        l2=plot(tt,Fstat2(:,1),'LineWidth',2,'Color',[0 0 0.5],'LineStyle','--' ); 
        yl=ylabel('Statistic');
        xl=xlabel('horizon (months)');
        ti=title('First Stage Robust F-statistic');
        l=legend([l1 l2],'Agency Commitments','Agency Purchases');
        set([xl,yl], 'FontName', 'AvantGarde','FontSize',10);
        set(l,'Location','SouthEast','Fontsize',12,'EdgeColor','white','FontName', 'AvantGarde','Box','off')
        set([ti], 'FontName', 'AvantGarde','FontSize',12);
        axis([min(tt)-1 max(tt)+1 0 max([Fstat1(:,1);Fstat2(:,1)])+2])
        box off
        set(gca,'LooseInset',get(gca,'TightInset'))
        str=strcat('figures/','FigureXV_Fstats');
        saveas(gcf,str,'epsc');

