clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Left Panel 
%%%%%%%%%%%%
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1966.99; SPEC.se  = 2006.99;   % Sample end points 
SPEC.lags     = 12; 
SPEC.hor      = 0:50;
SPEC.SCALE    = X_PINCT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = NARR./SPEC.SCALE;

RES.stock         = [ 0 ]; % 1: stock variable   0: flow variable
RES.LHSvariables  = {'PI'};

% Using Commitments
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NCOMM;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    RES.IRS1{jj}  = Estimate_cum_multipliers(LP);
    end
% Using Net Purchases
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NPURC;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    RES.IRS2{jj}  = Estimate_cum_multipliers(LP); 
    end

 FIG.stplot = [4 48];
 FIG.L90 = 0; FIG.L95=1;
 FIG.shift    = [0 0];
 FIG.fill     = 0; 
 FIG.legendpos   = 3; 
 for jj =1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = 3; 
 FIG.name     = strcat('FigureXIX_',RES.LHSvariables{jj});  
 FIG.legend   = {'Agency Commitments','Agency Purchases'};
 plot_cumm(RES.IRS1{jj},RES.IRS2{jj},FIG,FIG.legendpos(jj));
 end
 
 
% Right Panel
%%%%%%%%%%%%%
SPEC.SCALE    = X_ORIGT;
MCONTROLS2    = MCONTROLS;
MCONTROLS2(:,1:2) = [NCOMM./X_ORIGT NPURC./X_ORIGT];
SPEC.CONTROLS = [lagmatrix([MCONTROLS2 RCONTROLS CCONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.INS      = NARR./SPEC.SCALE;

% Using Commitments
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NCOMM;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    RES.IRS1{jj}  = Estimate_cum_multipliers(LP);
    end

% Using Net Purchases
    for jj = 1:length(RES.LHSvariables)        
    LP            = SPEC;
    LP.P          = NPURC;
    LP.Y          = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}})))./PLEVEL; 
    LP.stock      = RES.stock(jj);
    RES.IRS2{jj}  = Estimate_cum_multipliers(LP); 
    end

 FIG.stplot = [4 48];
 FIG.L90 = 0; FIG.L95=1;
 FIG.shift    = [0 0];
 FIG.fill     = 0; 
 FIG.legendpos   = 3; 
 for jj =1:size(RES.LHSvariables,2)
 FIG.figlabel = DATASET.FIGLABELS{cell2mat(values(DATASET.MAP,{RES.LHSvariables{jj}}))}; 
 FIG.units    = 3; 
 FIG.name     = strcat('FigureXIX_right_',RES.LHSvariables{jj});  
 FIG.legend   = {'Agency Commitments','Agency Purchases'};
 plot_cumm(RES.IRS1{jj},RES.IRS2{jj},FIG,FIG.legendpos(jj));
 end
 
 
 
 