clear all;  close all;
addpath('auxiliary_files')

Generate_VARIABLES

% Additional Lagged Controls:
ECONTROLS = [log(GSE_index./index_m) log(index_m./index_f)];
% Contemporaneous Controls:
WCONTROLS = [log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'MDEBT'})))./PLEVEL)...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'CONV'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SBAA','TB3','GS10'})))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'SCONV'})))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HPRICE'})))./PLEVEL)...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'HSTARTS'}))))...
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PCEPI'}))))...
             DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'UNRATE'})))... 
             log(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'PINC'}))))...
             log(index_re./index_m)-lagmatrix(log(index_re./index_m),1)...
             log(index_m./index_f)-lagmatrix(log(index_m./index_f),1)];
WCONTROLS(:,[2 8 10 12]) = WCONTROLS(:,[2 8 10 12])-lagmatrix(WCONTROLS(:,[2 8 10 12]),1);

% Specification
SPEC.dates    = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'DATES'})));
SPEC.sb       = 1971+7/12; 
SPEC.se       = 2006.99;
SPEC.lags     = 12; 
SPEC.hor      = 0:23;
SPEC.SCALE    = X_ORIGT;
SPEC.DET      = ones(length(SPEC.dates),1); % Deterministic Terms
SPEC.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS ECONTROLS],1:SPEC.lags) SPEC.DET];
SPEC.P        = NCOMM;
SPEC.INS      = log(GSE_index./index_m)-lagmatrix(log(GSE_index./index_m),1);
SPEC.WCONTROLS= WCONTROLS;

LP=SPEC;

    % Controls   
    CC  = [LP.CONTROLS LP.WCONTROLS];  % Lagged controls
    CONTROLS = CC((LP.dates>=LP.sb)&(LP.dates<=LP.se),:); 

    ZZ1  = LP.INS;    
    Z1 = ZZ1((LP.dates>=LP.sb)&(LP.dates<=LP.se),:);
    dates =LP.dates((LP.dates>=LP.sb)&(LP.dates<=LP.se),:) ;
    sel = (isnan(sum([Z1 CONTROLS],2))==0)&(dates<=LP.se);
    zdates = dates(sel,:);
    Z = Z1(sel,:)-CONTROLS(sel,:)*[CONTROLS(sel,:)\Z1(sel,:)]; 

    ER  = zeros(length(GSE_index),1);
    ER2 = NaN*zeros(length(Z),1);
    ER2(sel,1) = Z;
    ER((LP.dates>=LP.sb)&(LP.dates<=LP.se),1) = ER2;


SAM.sb = 1968;
SAM.se = 2008; DATES(end)+3/12;

%Credit cycle peaks
pks  = [1955.50 1959.00 1965.75 1968.75 1972.75 1978.00 1980.75 1990.00 1998.25 2007.25];
thrs = [1957.75  1960.25 1966.50 1970.00 1974.50 1980.00 1981.75 1992.75 1998.75 2014.75];
SCALE = sum(lagmatrix(DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'ORIG'}))),[1:12]),2);
NARRX = DATASET.TSERIES(:,cell2mat(values(DATASET.MAP,{'NARR_EX'})))./SCALE;

figure 
    box off
    hold on
    vars = [NARRX*100;zscore(Z)];
    ax1=[min(vars(:))-0.1*abs(min(vars(:))),max(vars(:))+0.1*abs(max(vars(:)))];
    for j=1:length(pks)   
     Yy=[ax1(1) ax1(1) ax1(2) ax1(2) ];
     Xx=[pks(j),thrs(j),thrs(j),pks(j)];
     h=fill(Xx,Yy, [0.9 0.9 0.9]);
     set(h,'EdgeColor','None');
     end
    b1=bar(DATES,NARRX*100,'LineWidth',5,'FaceColor',[0 0 0.5]);
    b2=plot(zdates,zscore(Z),'LineWidth',1,'Color', [0.9 0 0]);
    plot(DATES,0*ones(length(DATES),1),'k-')
    vline(0,'k')
    yl = ylabel('percent');
    l=legend([b1 b2],'Narrative Policy Indicator','GSE Excess Return Shocks (Standardized)');
    xl=xlabel(' ');
    axis([SAM.sb SAM.se ax1(1) ax1(2)])
    set([yl,xl], 'FontName', 'AvantGarde','FontSize',10);
    set([l], 'FontName', 'AvantGarde','FontSize',12,'Box','off','Location','SouthWest');
    set(gca,'LooseInset',get(gca,'TightInset'))
    set(gca, 'Layer','top')
    saveas(gcf,'figures/FigureXIV_ER','epsc')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
LP.sb       = 1971+7/12; LP.se  = 2006.99;
LP.lags     = 12;
LP.hor      = 0:23;
LP.SCALE    = X_ORIGT;
LP.CONTROLS = [lagmatrix([MCONTROLS RCONTROLS CCONTROLS ],1:SPEC.lags) SPEC.DET];
LP.WCONTROLS= [];
LP.DET      = [ones(length(LP.dates),1)];
LP.P1       = NCOMM;
LP.INS1     = NARR./SPEC.SCALE;
   
LP.vars     = log(cumprod(1+ER));
RES.IRSa    = Estimate_irs_ap_shock(LP);

FIG.stplot   = [0 24];
FIG.figlabel = 'Cumulative GSE Excess Returns Shocks';
FIG.units    = 1; 
FIG.fill     = 1; 
FIG.name     = 'FigureXIV_ER_irs';
FIG.shift    = [0 0];
plot_irs(RES.IRSa,FIG)




